/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.ManagementRegistration;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.AcceptListenerSettable;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.management.XnioServerMXBean;
import org.xnio.nio.AbstractNioChannel;
import org.xnio.nio.Log;
import org.xnio.nio.NioSocketStreamConnection;
import org.xnio.nio.NioTcpServerHandle;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.WorkerThread;

final class NioTcpServer
extends AbstractNioChannel<NioTcpServer>
implements AcceptingChannel<StreamConnection>,
AcceptListenerSettable<NioTcpServer> {
    private static final String FQCN = NioTcpServer.class.getName();
    private volatile ChannelListener<? super NioTcpServer> acceptListener;
    private final NioTcpServerHandle[] handles;
    private final ServerSocketChannel channel;
    private final ServerSocket socket;
    private final ManagementRegistration mbeanHandle;
    private static final Set<Option<?>> options = Option.setBuilder().add(Options.REUSE_ADDRESSES).add(Options.RECEIVE_BUFFER).add(Options.SEND_BUFFER).add(Options.KEEP_ALIVE).add(Options.TCP_OOB_INLINE).add(Options.TCP_NODELAY).add(Options.CONNECTION_HIGH_WATER).add(Options.CONNECTION_LOW_WATER).add(Options.READ_TIMEOUT).add(Options.WRITE_TIMEOUT).create();
    private volatile int keepAlive;
    private volatile int oobInline;
    private volatile int tcpNoDelay;
    private volatile int sendBuffer = -1;
    private volatile long connectionStatus = 0x3FFFFFFFFFFFFFFFL;
    private volatile int readTimeout;
    private volatile int writeTimeout;
    private volatile int tokenConnectionCount;
    volatile boolean resumed;
    private static final long CONN_LOW_MASK = Integer.MAX_VALUE;
    private static final long CONN_LOW_BIT = 0L;
    private static final long CONN_LOW_ONE = 1L;
    private static final long CONN_HIGH_MASK = 4611686016279904256L;
    private static final long CONN_HIGH_BIT = 31L;
    private static final long CONN_HIGH_ONE = 0x80000000L;
    private static final AtomicIntegerFieldUpdater<NioTcpServer> keepAliveUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "keepAlive");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> oobInlineUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "oobInline");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> tcpNoDelayUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "tcpNoDelay");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> sendBufferUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "sendBuffer");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> readTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "readTimeout");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> writeTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "writeTimeout");
    private static final AtomicLongFieldUpdater<NioTcpServer> connectionStatusUpdater = AtomicLongFieldUpdater.newUpdater(NioTcpServer.class, "connectionStatus");

    NioTcpServer(final NioXnioWorker worker, ServerSocketChannel channel, OptionMap optionMap, boolean useAcceptThreadOnly) throws IOException {
        super(worker);
        int i;
        int perThreadHighRem;
        int perThreadHigh;
        int perThreadLowRem;
        int perThreadLow;
        int connections;
        int tokens;
        int threadCount;
        WorkerThread[] threads;
        this.channel = channel;
        if (useAcceptThreadOnly) {
            threads = new WorkerThread[]{worker.getAcceptThread()};
            threadCount = 1;
            tokens = 0;
            connections = 0;
        } else {
            threads = worker.getAll();
            threadCount = threads.length;
            if (threadCount == 0) {
                throw Log.log.noThreads();
            }
            tokens = optionMap.get(Options.BALANCING_TOKENS, -1);
            connections = optionMap.get(Options.BALANCING_CONNECTIONS, 16);
            if (tokens != -1) {
                if (tokens < 1 || tokens >= threadCount) {
                    throw Log.log.balancingTokens();
                }
                if (connections < 1) {
                    throw Log.log.balancingConnectionCount();
                }
                this.tokenConnectionCount = connections;
            }
        }
        this.socket = channel.socket();
        if (optionMap.contains(Options.SEND_BUFFER)) {
            int sendBufferSize = optionMap.get(Options.SEND_BUFFER, 65536);
            if (sendBufferSize < 1) {
                throw Log.log.parameterOutOfRange("sendBufferSize");
            }
            sendBufferUpdater.set(this, sendBufferSize);
        }
        if (optionMap.contains(Options.KEEP_ALIVE)) {
            keepAliveUpdater.lazySet(this, optionMap.get(Options.KEEP_ALIVE, false) ? 1 : 0);
        }
        if (optionMap.contains(Options.TCP_OOB_INLINE)) {
            oobInlineUpdater.lazySet(this, optionMap.get(Options.TCP_OOB_INLINE, false) ? 1 : 0);
        }
        if (optionMap.contains(Options.TCP_NODELAY)) {
            tcpNoDelayUpdater.lazySet(this, optionMap.get(Options.TCP_NODELAY, false) ? 1 : 0);
        }
        if (optionMap.contains(Options.READ_TIMEOUT)) {
            readTimeoutUpdater.lazySet(this, optionMap.get(Options.READ_TIMEOUT, 0));
        }
        if (optionMap.contains(Options.WRITE_TIMEOUT)) {
            writeTimeoutUpdater.lazySet(this, optionMap.get(Options.WRITE_TIMEOUT, 0));
        }
        if (optionMap.contains(Options.CONNECTION_HIGH_WATER) || optionMap.contains(Options.CONNECTION_LOW_WATER)) {
            int highWater = optionMap.get(Options.CONNECTION_HIGH_WATER, Integer.MAX_VALUE);
            int lowWater = optionMap.get(Options.CONNECTION_LOW_WATER, highWater);
            if (highWater <= 0) {
                throw NioTcpServer.badHighWater();
            }
            if (lowWater <= 0 || lowWater > highWater) {
                throw NioTcpServer.badLowWater(highWater);
            }
            long highLowWater = (long)highWater << 31 | (long)lowWater << 0;
            connectionStatusUpdater.lazySet(this, highLowWater);
            perThreadLow = lowWater / threadCount;
            perThreadLowRem = lowWater % threadCount;
            perThreadHigh = highWater / threadCount;
            perThreadHighRem = highWater % threadCount;
        } else {
            perThreadLow = Integer.MAX_VALUE;
            perThreadLowRem = 0;
            perThreadHigh = Integer.MAX_VALUE;
            perThreadHighRem = 0;
            connectionStatusUpdater.lazySet(this, 0x3FFFFFFFFFFFFFFFL);
        }
        final NioTcpServerHandle[] handles = new NioTcpServerHandle[threadCount];
        int length = threadCount;
        for (i = 0; i < length; ++i) {
            SelectionKey key = threads[i].registerChannel(channel);
            handles[i] = new NioTcpServerHandle(this, key, threads[i], i < perThreadHighRem ? perThreadHigh + 1 : perThreadHigh, i < perThreadLowRem ? perThreadLow + 1 : perThreadLow);
            key.attach(handles[i]);
        }
        this.handles = handles;
        if (tokens > 0) {
            for (i = 0; i < threadCount; ++i) {
                handles[i].initializeTokenCount(i < tokens ? connections : 0);
            }
        }
        this.mbeanHandle = worker.registerServerMXBean(new XnioServerMXBean(){

            public String getProviderName() {
                return "nio";
            }

            public String getWorkerName() {
                return worker.getName();
            }

            public String getBindAddress() {
                return String.valueOf(NioTcpServer.this.getLocalAddress());
            }

            public int getConnectionCount() {
                AtomicInteger counter = new AtomicInteger();
                CountDownLatch latch = new CountDownLatch(handles.length);
                for (NioTcpServerHandle handle : handles) {
                    handle.getWorkerThread().execute(() -> {
                        counter.getAndAdd(handle.getConnectionCount());
                        latch.countDown();
                    });
                }
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return counter.get();
            }

            public int getConnectionLimitHighWater() {
                return NioTcpServer.getHighWater(NioTcpServer.this.connectionStatus);
            }

            public int getConnectionLimitLowWater() {
                return NioTcpServer.getLowWater(NioTcpServer.this.connectionStatus);
            }
        });
    }

    private static IllegalArgumentException badLowWater(int highWater) {
        return new IllegalArgumentException("Low water must be greater than 0 and less than or equal to high water (" + highWater + ")");
    }

    private static IllegalArgumentException badHighWater() {
        return new IllegalArgumentException("High water must be greater than 0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.channel.close();
        }
        finally {
            for (NioTcpServerHandle handle : this.handles) {
                handle.cancelKey(false);
            }
            IoUtils.safeClose((AutoCloseable)this.mbeanHandle);
        }
    }

    public boolean supportsOption(Option<?> option) {
        return options.contains(option);
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        if (option == Options.REUSE_ADDRESSES) {
            return (T)option.cast((Object)this.socket.getReuseAddress());
        }
        if (option == Options.RECEIVE_BUFFER) {
            return (T)option.cast((Object)this.socket.getReceiveBufferSize());
        }
        if (option == Options.SEND_BUFFER) {
            int value = this.sendBuffer;
            return (T)(value == -1 ? null : option.cast((Object)value));
        }
        if (option == Options.KEEP_ALIVE) {
            return (T)option.cast((Object)(this.keepAlive != 0 ? 1 : 0));
        }
        if (option == Options.TCP_OOB_INLINE) {
            return (T)option.cast((Object)(this.oobInline != 0 ? 1 : 0));
        }
        if (option == Options.TCP_NODELAY) {
            return (T)option.cast((Object)(this.tcpNoDelay != 0 ? 1 : 0));
        }
        if (option == Options.READ_TIMEOUT) {
            return (T)option.cast((Object)this.readTimeout);
        }
        if (option == Options.WRITE_TIMEOUT) {
            return (T)option.cast((Object)this.writeTimeout);
        }
        if (option == Options.CONNECTION_HIGH_WATER) {
            return (T)option.cast((Object)NioTcpServer.getHighWater(this.connectionStatus));
        }
        if (option == Options.CONNECTION_LOW_WATER) {
            return (T)option.cast((Object)NioTcpServer.getLowWater(this.connectionStatus));
        }
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        Comparable<Boolean> old;
        if (option == Options.REUSE_ADDRESSES) {
            old = this.socket.getReuseAddress();
            this.socket.setReuseAddress((Boolean)Options.REUSE_ADDRESSES.cast(value, (Object)Boolean.FALSE));
        } else if (option == Options.RECEIVE_BUFFER) {
            old = this.socket.getReceiveBufferSize();
            int newValue = (Integer)Options.RECEIVE_BUFFER.cast(value, (Object)65536);
            if (newValue < 1) {
                throw Log.log.optionOutOfRange("RECEIVE_BUFFER");
            }
            this.socket.setReceiveBufferSize(newValue);
        } else if (option == Options.SEND_BUFFER) {
            int newValue = (Integer)Options.SEND_BUFFER.cast(value, (Object)65536);
            if (newValue < 1) {
                throw Log.log.optionOutOfRange("SEND_BUFFER");
            }
            int oldValue = sendBufferUpdater.getAndSet(this, newValue);
            old = oldValue == -1 ? null : Integer.valueOf(oldValue);
        } else if (option == Options.KEEP_ALIVE) {
            old = keepAliveUpdater.getAndSet(this, (Boolean)Options.KEEP_ALIVE.cast(value, (Object)Boolean.FALSE) != false ? 1 : 0) != 0;
        } else if (option == Options.TCP_OOB_INLINE) {
            old = oobInlineUpdater.getAndSet(this, (Boolean)Options.TCP_OOB_INLINE.cast(value, (Object)Boolean.FALSE) != false ? 1 : 0) != 0;
        } else if (option == Options.TCP_NODELAY) {
            old = tcpNoDelayUpdater.getAndSet(this, (Boolean)Options.TCP_NODELAY.cast(value, (Object)Boolean.FALSE) != false ? 1 : 0) != 0;
        } else if (option == Options.READ_TIMEOUT) {
            old = readTimeoutUpdater.getAndSet(this, (Integer)Options.READ_TIMEOUT.cast(value, (Object)0));
        } else if (option == Options.WRITE_TIMEOUT) {
            old = writeTimeoutUpdater.getAndSet(this, (Integer)Options.WRITE_TIMEOUT.cast(value, (Object)0));
        } else if (option == Options.CONNECTION_HIGH_WATER) {
            old = NioTcpServer.getHighWater(this.updateWaterMark(-1, (Integer)Options.CONNECTION_HIGH_WATER.cast(value, (Object)Integer.MAX_VALUE)));
        } else if (option == Options.CONNECTION_LOW_WATER) {
            old = NioTcpServer.getLowWater(this.updateWaterMark((Integer)Options.CONNECTION_LOW_WATER.cast(value, (Object)Integer.MAX_VALUE), -1));
        } else {
            return null;
        }
        return (T)option.cast((Object)old);
    }

    private long updateWaterMark(int reqNewLowWater, int reqNewHighWater) {
        int newHighWater;
        int newLowWater;
        long newVal;
        long oldVal;
        assert (reqNewLowWater != -1 || reqNewHighWater != -1);
        assert (reqNewLowWater == -1 || reqNewHighWater == -1 || reqNewLowWater <= reqNewHighWater);
        do {
            oldVal = this.connectionStatus;
            int oldLowWater = NioTcpServer.getLowWater(oldVal);
            int oldHighWater = NioTcpServer.getHighWater(oldVal);
            newLowWater = reqNewLowWater == -1 ? oldLowWater : reqNewLowWater;
            int n = newHighWater = reqNewHighWater == -1 ? oldHighWater : reqNewHighWater;
            if (reqNewLowWater != -1 && newLowWater > newHighWater) {
                newHighWater = newLowWater;
            } else if (reqNewHighWater != -1 && newHighWater < newLowWater) {
                newLowWater = newHighWater;
            }
            if (oldLowWater != newLowWater || oldHighWater != newHighWater) continue;
            return oldVal;
        } while (!connectionStatusUpdater.compareAndSet(this, oldVal, newVal = (long)newLowWater << 0 | (long)newHighWater << 31));
        NioTcpServerHandle[] conduits = this.handles;
        int threadCount = conduits.length;
        int perThreadLow = newLowWater / threadCount;
        int perThreadLowRem = newLowWater % threadCount;
        int perThreadHigh = newHighWater / threadCount;
        int perThreadHighRem = newHighWater % threadCount;
        for (int i = 0; i < conduits.length; ++i) {
            NioTcpServerHandle conduit = conduits[i];
            conduit.executeSetTask(i < perThreadHighRem ? perThreadHigh + 1 : perThreadHigh, i < perThreadLowRem ? perThreadLow + 1 : perThreadLow);
        }
        return oldVal;
    }

    private static int getHighWater(long value) {
        return (int)((value & 0x3FFFFFFF80000000L) >> 31);
    }

    private static int getLowWater(long value) {
        return (int)((value & Integer.MAX_VALUE) >> 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NioSocketStreamConnection accept() throws ClosedChannelException {
        block15: {
            WorkerThread current = WorkerThread.getCurrent();
            if (current == null) {
                return null;
            }
            NioTcpServerHandle handle = this.handles.length == 1 ? this.handles[0] : this.handles[current.getNumber()];
            if (!handle.getConnection()) {
                return null;
            }
            boolean ok = false;
            try {
                NioSocketStreamConnection nioSocketStreamConnection;
                block16: {
                    SocketChannel accepted = this.channel.accept();
                    if (accepted == null) break block15;
                    try {
                        int hash = ThreadLocalRandom.current().nextInt();
                        accepted.configureBlocking(false);
                        Socket socket = accepted.socket();
                        socket.setKeepAlive(this.keepAlive != 0);
                        socket.setOOBInline(this.oobInline != 0);
                        socket.setTcpNoDelay(this.tcpNoDelay != 0);
                        int sendBuffer = this.sendBuffer;
                        if (sendBuffer > 0) {
                            socket.setSendBufferSize(sendBuffer);
                        }
                        WorkerThread ioThread = this.worker.getIoThread(hash);
                        SelectionKey selectionKey = ioThread.registerChannel(accepted);
                        NioSocketStreamConnection newConnection = new NioSocketStreamConnection(ioThread, selectionKey, handle);
                        newConnection.setOption(Options.READ_TIMEOUT, this.readTimeout);
                        newConnection.setOption(Options.WRITE_TIMEOUT, this.writeTimeout);
                        ok = true;
                        handle.resetBackOff();
                        nioSocketStreamConnection = newConnection;
                        if (ok) break block16;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (!ok) {
                                IoUtils.safeClose((Closeable)accepted);
                            }
                            throw throwable;
                        }
                        catch (ClosedChannelException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            handle.startBackOff();
                            Log.log.acceptFailed(e, handle.getBackOffTime());
                            NioSocketStreamConnection nioSocketStreamConnection2 = null;
                            return nioSocketStreamConnection2;
                        }
                        finally {
                        }
                    }
                    IoUtils.safeClose((Closeable)accepted);
                }
                return nioSocketStreamConnection;
            }
            finally {
                if (!ok) {
                    handle.freeConnection();
                }
            }
        }
        return null;
    }

    public String toString() {
        return String.format("TCP server (NIO) <%s>", Integer.toHexString(this.hashCode()));
    }

    public ChannelListener<? super NioTcpServer> getAcceptListener() {
        return this.acceptListener;
    }

    public void setAcceptListener(ChannelListener<? super NioTcpServer> acceptListener) {
        this.acceptListener = acceptListener;
    }

    public ChannelListener.Setter<NioTcpServer> getAcceptSetter() {
        return new AcceptListenerSettable.Setter((AcceptListenerSettable)this);
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public SocketAddress getLocalAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        SocketAddress address = this.getLocalAddress();
        return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
    }

    public void suspendAccepts() {
        this.resumed = false;
        this.doResume(0);
    }

    public void resumeAccepts() {
        this.resumed = true;
        this.doResume(16);
    }

    public boolean isAcceptResumed() {
        return this.resumed;
    }

    private void doResume(int op) {
        if (op == 0) {
            for (NioTcpServerHandle handle : this.handles) {
                handle.suspend();
            }
        } else {
            for (NioTcpServerHandle handle : this.handles) {
                handle.resume();
            }
        }
    }

    public void wakeupAccepts() {
        Log.tcpServerLog.logf(FQCN, Logger.Level.TRACE, null, "Wake up accepts on %s", this);
        this.resumeAccepts();
        NioTcpServerHandle[] handles = this.handles;
        int idx = IoUtils.getThreadLocalRandom().nextInt(handles.length);
        handles[idx].wakeup(16);
    }

    public void awaitAcceptable() throws IOException {
        throw Log.log.unsupported("awaitAcceptable");
    }

    public void awaitAcceptable(long time, TimeUnit timeUnit) throws IOException {
        throw Log.log.unsupported("awaitAcceptable");
    }

    @Deprecated
    public XnioExecutor getAcceptThread() {
        return this.getIoThread();
    }

    NioTcpServerHandle getHandle(int number) {
        return this.handles[number];
    }

    int getTokenConnectionCount() {
        return this.tokenConnectionCount;
    }
}

