/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.cdi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import org.glassfish.soteria.cdi.CdiUtils;

public class DefaultIdentityStoreHandler
implements IdentityStoreHandler {
    private List<IdentityStore> authenticationIdentityStores;
    private List<IdentityStore> authorizationIdentityStores;

    public void init() {
        List<IdentityStore> identityStores = CdiUtils.getBeanReferencesByType(IdentityStore.class, false);
        this.authenticationIdentityStores = identityStores.stream().filter(i -> i.validationTypes().contains(IdentityStore.ValidationType.VALIDATE)).sorted(Comparator.comparing(IdentityStore::priority)).collect(Collectors.toList());
        this.authorizationIdentityStores = identityStores.stream().filter(i -> i.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS) && !i.validationTypes().contains(IdentityStore.ValidationType.VALIDATE)).sorted(Comparator.comparing(IdentityStore::priority)).collect(Collectors.toList());
    }

    public CredentialValidationResult validate(Credential credential) {
        CredentialValidationResult validationResult = null;
        IdentityStore identityStore = null;
        boolean isGotAnInvalidResult = false;
        for (IdentityStore authenticationIdentityStore : this.authenticationIdentityStores) {
            validationResult = authenticationIdentityStore.validate(credential);
            if (validationResult.getStatus() == CredentialValidationResult.Status.VALID) {
                identityStore = authenticationIdentityStore;
                break;
            }
            if (validationResult.getStatus() != CredentialValidationResult.Status.INVALID) continue;
            isGotAnInvalidResult = true;
        }
        if (validationResult == null || validationResult.getStatus() != CredentialValidationResult.Status.VALID) {
            if (isGotAnInvalidResult) {
                return CredentialValidationResult.INVALID_RESULT;
            }
            return CredentialValidationResult.NOT_VALIDATED_RESULT;
        }
        final HashSet groups = new HashSet();
        if (identityStore.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) {
            groups.addAll(validationResult.getCallerGroups());
        }
        final CredentialValidationResult finalResult = validationResult;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                for (IdentityStore authorizationIdentityStore : DefaultIdentityStoreHandler.this.authorizationIdentityStores) {
                    groups.addAll(authorizationIdentityStore.getCallerGroups(finalResult));
                }
                return null;
            }
        });
        return new CredentialValidationResult(validationResult.getIdentityStoreId(), validationResult.getCallerPrincipal(), validationResult.getCallerDn(), validationResult.getCallerUniqueId(), groups);
    }
}

