/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.jdbc.mapper;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.common.codec.Base64Alphabet;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.jdbc.KeyMapper;
import org.wildfly.security.auth.realm.jdbc._private.ElytronMessages;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.HashPasswordSpec;
import org.wildfly.security.password.spec.IteratedHashPasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedHashPasswordSpec;
import org.wildfly.security.password.spec.SaltedHashPasswordSpec;
import org.wildfly.security.password.util.ModularCrypt;

public class PasswordKeyMapper
implements KeyMapper {
    private final int hashColumn;
    private final int saltColumn;
    private final int iterationCountColumn;
    private final int defaultIterationCount;
    private final int algorithmColumn;
    private final String defaultAlgorithm;
    private final Encoding hashEncoding;
    private final Encoding saltEncoding;

    PasswordKeyMapper(Builder builder) {
        int hashColumn = builder.hashColumn;
        Assert.checkMinimumParameter((String)"hashColumn", (int)1, (int)hashColumn);
        this.hashColumn = hashColumn;
        int saltColumn = builder.saltColumn;
        if (saltColumn != -1) {
            Assert.checkMinimumParameter((String)"saltColumn", (int)1, (int)saltColumn);
        }
        this.saltColumn = saltColumn;
        int iterationCountColumn = builder.iterationCountColumn;
        if (iterationCountColumn != -1) {
            Assert.checkMinimumParameter((String)"iterationCountColumn", (int)1, (int)iterationCountColumn);
        }
        this.iterationCountColumn = iterationCountColumn;
        int defaultIterationCount = builder.defaultIterationCount;
        if (defaultIterationCount != -1) {
            Assert.checkMinimumParameter((String)"defaultIterationCount", (int)1, (int)defaultIterationCount);
        }
        this.defaultIterationCount = defaultIterationCount;
        int algorithmColumn = builder.algorithmColumn;
        if (algorithmColumn != -1) {
            Assert.checkMinimumParameter((String)"algorithmColumn", (int)1, (int)algorithmColumn);
        }
        this.algorithmColumn = algorithmColumn;
        this.defaultAlgorithm = builder.defaultAlgorithm;
        this.hashEncoding = (Encoding)((Object)Assert.checkNotNullParam((String)"hashEncoding", (Object)((Object)builder.hashEncoding)));
        this.saltEncoding = (Encoding)((Object)Assert.checkNotNullParam((String)"saltEncoding", (Object)((Object)builder.saltEncoding)));
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
        return PasswordCredential.class.isAssignableFrom(credentialType) ? SupportLevel.POSSIBLY_SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) {
        return PasswordCredential.canVerifyEvidence(evidenceType, (String)algorithmName) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    public String getDefaultAlgorithm() {
        return this.defaultAlgorithm;
    }

    public int getHashColumn() {
        return this.hashColumn;
    }

    public int getSaltColumn() {
        return this.saltColumn;
    }

    public int getIterationCountColumn() {
        return this.iterationCountColumn;
    }

    public int getDefaultIterationCount() {
        return this.defaultIterationCount;
    }

    public int getAlgorithmColumn() {
        return this.algorithmColumn;
    }

    private static byte[] getBinaryColumn(ResultSetMetaData metaData, ResultSet resultSet, int column, Encoding encoding) throws SQLException {
        if (column == -1) {
            return null;
        }
        int columnType = metaData.getColumnType(column);
        switch (columnType) {
            case -4: 
            case -3: 
            case -2: {
                return resultSet.getBytes(column);
            }
            case -16: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return PasswordKeyMapper.decodeColumn(resultSet.getString(column), encoding);
            }
        }
        Object object = resultSet.getObject(column);
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return PasswordKeyMapper.decodeColumn((String)object, encoding);
        }
        return null;
    }

    private static byte[] decodeColumn(String string, Encoding encoding) {
        switch (encoding) {
            case BASE64: {
                return CodePointIterator.ofString((String)string).base64Decode(Base64Alphabet.STANDARD, false).drain();
            }
            case HEX: {
                return CodePointIterator.ofString((String)string).hexDecode().drain();
            }
        }
        throw new IllegalStateException();
    }

    private static String getStringColumn(ResultSetMetaData metaData, ResultSet resultSet, int column) throws SQLException {
        if (column == -1) {
            return null;
        }
        int columnType = metaData.getColumnType(column);
        switch (columnType) {
            case -4: 
            case -3: 
            case -2: {
                return new String(resultSet.getBytes(column), StandardCharsets.UTF_8);
            }
            case -16: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return resultSet.getString(column);
            }
        }
        Object object = resultSet.getObject(column);
        if (object instanceof byte[]) {
            return new String((byte[])object, StandardCharsets.UTF_8);
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    @Override
    public Credential map(ResultSet resultSet, Supplier<Provider[]> providers) throws SQLException {
        Object passwordSpec;
        PasswordFactory passwordFactory;
        String s;
        byte[] hash = null;
        char[] clear = null;
        byte[] salt = null;
        String algorithmName = this.getDefaultAlgorithm();
        ResultSetMetaData metaData = resultSet.getMetaData();
        if (this.algorithmColumn > 0 && (algorithmName = resultSet.getString(this.algorithmColumn)) == null) {
            algorithmName = this.getDefaultAlgorithm();
        }
        if ("clear".equals(algorithmName)) {
            s = PasswordKeyMapper.getStringColumn(metaData, resultSet, this.hashColumn);
            if (s != null) {
                clear = s.toCharArray();
            } else {
                hash = PasswordKeyMapper.getBinaryColumn(metaData, resultSet, this.hashColumn, this.hashEncoding);
            }
        } else {
            char[] chars;
            String identified;
            if (this.saltColumn == -1 && this.iterationCountColumn == -1 && (s = PasswordKeyMapper.getStringColumn(metaData, resultSet, this.hashColumn)) != null && (identified = ModularCrypt.identifyAlgorithm((char[])(chars = s.toCharArray()))) != null) {
                try {
                    Password modularCryptPassword = ModularCrypt.decode((char[])chars);
                    if (ElytronMessages.log.isTraceEnabled()) {
                        ElytronMessages.log.tracef("Key Mapper: Password credential created using Modular Crypt algorithm [%s]", identified);
                    }
                    return new PasswordCredential(modularCryptPassword);
                }
                catch (InvalidKeySpecException e) {
                    ElytronMessages.log.tracef(e, "Key Mapper: Unable to identify Modular Crypt algorithm [%s]", identified);
                }
            }
            hash = PasswordKeyMapper.getBinaryColumn(metaData, resultSet, this.hashColumn, this.hashEncoding);
        }
        if (this.saltColumn > 0) {
            salt = PasswordKeyMapper.getBinaryColumn(metaData, resultSet, this.saltColumn, this.saltEncoding);
        }
        int iterationCount = this.iterationCountColumn > 0 ? resultSet.getInt(this.iterationCountColumn) : this.defaultIterationCount;
        try {
            passwordFactory = PasswordFactory.getInstance((String)algorithmName, providers);
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.couldNotObtainPasswordFactoryForAlgorithm(algorithmName, e);
        }
        if (hash != null) {
            passwordSpec = salt != null ? (iterationCount > 0 ? new IteratedSaltedHashPasswordSpec(hash, salt, iterationCount) : new SaltedHashPasswordSpec(hash, salt)) : (iterationCount > 0 ? new IteratedHashPasswordSpec(hash, iterationCount) : new HashPasswordSpec(hash));
        } else if (clear != null) {
            passwordSpec = new ClearPasswordSpec(clear);
        } else {
            return null;
        }
        try {
            Password password = passwordFactory.generatePassword((KeySpec)passwordSpec);
            if (ElytronMessages.log.isTraceEnabled()) {
                ElytronMessages.log.tracef("Key Mapper: Password credential created using algorithm column value [%s]", algorithmName);
            }
            return new PasswordCredential(password);
        }
        catch (InvalidKeySpecException e) {
            throw ElytronMessages.log.invalidPasswordKeySpecificationForAlgorithm(algorithmName, e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        int hashColumn = -1;
        int saltColumn = -1;
        int iterationCountColumn = -1;
        int defaultIterationCount = -1;
        int algorithmColumn = -1;
        String defaultAlgorithm;
        Encoding hashEncoding = Encoding.BASE64;
        Encoding saltEncoding = Encoding.BASE64;

        Builder() {
        }

        public int getHashColumn() {
            return this.hashColumn;
        }

        public Builder setHashColumn(int hashColumn) {
            this.hashColumn = hashColumn;
            return this;
        }

        public int getSaltColumn() {
            return this.saltColumn;
        }

        public Builder setSaltColumn(int saltColumn) {
            this.saltColumn = saltColumn;
            return this;
        }

        public int getIterationCountColumn() {
            return this.iterationCountColumn;
        }

        public Builder setIterationCountColumn(int iterationCountColumn) {
            this.iterationCountColumn = iterationCountColumn;
            return this;
        }

        public int getDefaultIterationCount() {
            return this.defaultIterationCount;
        }

        public Builder setDefaultIterationCount(int defaultIterationCount) {
            this.defaultIterationCount = defaultIterationCount;
            return this;
        }

        public int getAlgorithmColumn() {
            return this.algorithmColumn;
        }

        public Builder setAlgorithmColumn(int algorithmColumn) {
            this.algorithmColumn = algorithmColumn;
            return this;
        }

        public String getDefaultAlgorithm() {
            return this.defaultAlgorithm;
        }

        public Builder setDefaultAlgorithm(String defaultAlgorithm) {
            this.defaultAlgorithm = defaultAlgorithm;
            return this;
        }

        public Encoding getHashEncoding() {
            return this.hashEncoding;
        }

        public Builder setHashEncoding(Encoding hashEncoding) {
            this.hashEncoding = hashEncoding;
            return this;
        }

        public Encoding getSaltEncoding() {
            return this.saltEncoding;
        }

        public Builder setSaltEncoding(Encoding saltEncoding) {
            this.saltEncoding = saltEncoding;
            return this;
        }

        public PasswordKeyMapper build() {
            return new PasswordKeyMapper(this);
        }
    }

    public static enum Encoding {
        BASE64,
        HEX;

    }
}

