/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.velocity.Template;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Macro;
import org.apache.velocity.runtime.directive.VelocimacroProxy;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;

public class VelocimacroManager {
    private boolean registerFromLib = false;
    private final Map globalNamespace;
    private final Map libraries = new ConcurrentHashMap(17, 0.5f, 20);
    private RuntimeServices rsvc = null;
    private boolean namespacesOn = true;
    private boolean inlineLocalMode = false;
    private boolean inlineReplacesGlobal = false;

    VelocimacroManager(RuntimeServices rsvc) {
        this.globalNamespace = new ConcurrentHashMap(101, 0.5f, 20);
        this.rsvc = rsvc;
    }

    public boolean addVM(String vmName, Node macroBody, List<Macro.MacroArg> macroArgs, Template definingTemplate, boolean canReplaceGlobalMacro) {
        if (macroBody == null) {
            throw new VelocityException("Null AST for " + vmName + " in " + definingTemplate.getName());
        }
        MacroEntry me = new MacroEntry(vmName, macroBody, macroArgs, definingTemplate.getName(), this.rsvc);
        me.setFromLibrary(this.registerFromLib);
        boolean isLib = true;
        MacroEntry exist = (MacroEntry)this.globalNamespace.get(vmName);
        if (this.registerFromLib) {
            this.libraries.put(definingTemplate.getName(), definingTemplate);
        } else {
            isLib = this.libraries.containsKey(definingTemplate.getName());
        }
        if (!isLib && this.usingNamespaces()) {
            definingTemplate.getMacros().put(vmName, me);
            return true;
        }
        if (exist != null) {
            me.setFromLibrary(exist.getFromLibrary());
        }
        this.globalNamespace.put(vmName, me);
        return true;
    }

    public VelocimacroProxy get(String vmName, Template renderingTemplate, Template template) {
        MacroEntry me;
        if (this.inlineReplacesGlobal && renderingTemplate != null && (me = (MacroEntry)renderingTemplate.getMacros().get(vmName)) != null) {
            return me.getProxy();
        }
        if (this.usingNamespaces() && template != null) {
            me = (MacroEntry)template.getMacros().get(vmName);
            if (template.getMacros().size() > 0 && me != null) {
                return me.getProxy();
            }
        }
        if ((me = (MacroEntry)this.globalNamespace.get(vmName)) != null) {
            return me.getProxy();
        }
        return null;
    }

    public void setNamespaceUsage(boolean namespaceOn) {
        this.namespacesOn = namespaceOn;
    }

    public void setRegisterFromLib(boolean registerFromLib) {
        this.registerFromLib = registerFromLib;
    }

    public void setTemplateLocalInlineVM(boolean inlineLocalMode) {
        this.inlineLocalMode = inlineLocalMode;
    }

    private boolean usingNamespaces() {
        if (!this.namespacesOn) {
            return false;
        }
        return this.inlineLocalMode;
    }

    public String getLibraryName(String vmName, Template template) {
        MacroEntry me;
        if (this.usingNamespaces() && (me = (MacroEntry)template.getMacros().get(vmName)) != null) {
            return null;
        }
        me = (MacroEntry)this.globalNamespace.get(vmName);
        if (me != null) {
            return me.getSourceTemplate();
        }
        return null;
    }

    public void setInlineReplacesGlobal(boolean is) {
        this.inlineReplacesGlobal = is;
    }

    private static class MacroEntry {
        private final String vmName;
        private final List<Macro.MacroArg> macroArgs;
        private final String sourceTemplate;
        private SimpleNode nodeTree = null;
        private boolean fromLibrary = false;
        private VelocimacroProxy vp;

        private MacroEntry(String vmName, Node macro, List<Macro.MacroArg> macroArgs, String sourceTemplate, RuntimeServices rsvc) {
            this.vmName = vmName;
            this.macroArgs = macroArgs;
            this.nodeTree = (SimpleNode)macro;
            this.sourceTemplate = sourceTemplate;
            this.vp = new VelocimacroProxy();
            this.vp.init(rsvc);
            this.vp.setName(this.vmName);
            this.vp.setMacroArgs(this.macroArgs);
            this.vp.setNodeTree(this.nodeTree);
            this.vp.setLocation(macro.getLine(), macro.getColumn(), macro.getTemplate());
        }

        public void setFromLibrary(boolean fromLibrary) {
            this.fromLibrary = fromLibrary;
        }

        public boolean getFromLibrary() {
            return this.fromLibrary;
        }

        public String getSourceTemplate() {
            return this.sourceTemplate;
        }

        VelocimacroProxy getProxy() {
            return this.vp;
        }
    }
}

