/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.jboss.as.server.Services;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.DefaultCredentials;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.jms.WildFlyBindingRegistry;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JMSService
implements Service<JMSServerManager> {
    private final InjectedValue<ActiveMQServer> activeMQServer = new InjectedValue();
    private final InjectedValue<ExecutorService> serverExecutor = new InjectedValue();
    private final ServiceName serverServiceName;
    private final boolean overrideInVMSecurity;
    private JMSServerManager jmsServer;

    public static ServiceController<JMSServerManager> addService(ServiceTarget target, ServiceName serverServiceName, boolean overrideInVMSecurity) {
        JMSService service = new JMSService(serverServiceName, overrideInVMSecurity);
        ServiceBuilder builder = target.addService(JMSServices.getJmsManagerBaseServiceName(serverServiceName), (Service)service);
        builder.addDependency(serverServiceName, ActiveMQServer.class, service.activeMQServer);
        builder.requires(MessagingServices.ACTIVEMQ_CLIENT_THREAD_POOL);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        Services.addServerExecutorDependency((ServiceBuilder)builder, service.serverExecutor);
        return builder.install();
    }

    protected JMSService(ServiceName serverServiceName, boolean overrideInVMSecurity) {
        this.serverServiceName = serverServiceName;
        this.overrideInVMSecurity = overrideInVMSecurity;
    }

    public synchronized JMSServerManager getValue() throws IllegalStateException {
        if (this.jmsServer == null) {
            throw new IllegalStateException();
        }
        return this.jmsServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final StartContext context) throws StartException {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    JMSService.this.doStart(context);
                    context.complete();
                }
                catch (StartException e) {
                    context.failed(e);
                }
            }
        };
        try {
            ((ExecutorService)this.serverExecutor.getValue()).submit(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext context) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                JMSService.this.doStop(context);
                context.complete();
            }
        };
        try {
            ((ExecutorService)this.serverExecutor.getValue()).submit(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    private synchronized void doStart(StartContext context) throws StartException {
        final ServiceContainer serviceContainer = context.getController().getServiceContainer();
        ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(this.getClass());
        try {
            this.jmsServer = new JMSServerManagerImpl((ActiveMQServer)this.activeMQServer.getValue(), new WildFlyBindingRegistry(context.getController().getServiceContainer())){

                public void stop(ActiveMQServer server) {
                }
            };
            ((ActiveMQServer)this.activeMQServer.getValue()).registerActivationFailureListener(e -> {
                StartException se = new StartException((Throwable)e);
                context.failed(se);
            });
            ((ActiveMQServer)this.activeMQServer.getValue()).registerActivateCallback(new ActivateCallback(){
                private volatile ServiceController<Void> activeMQActivationController;

                public void preActivate() {
                }

                public void activated() {
                    if (JMSService.this.overrideInVMSecurity) {
                        ((ActiveMQServer)JMSService.this.activeMQServer.getValue()).getRemotingService().allowInvmSecurityOverride(new ActiveMQPrincipal(DefaultCredentials.getUsername(), DefaultCredentials.getPassword()));
                    }
                    if (serviceContainer.isShutdown()) {
                        return;
                    }
                    if (this.activeMQActivationController == null) {
                        this.activeMQActivationController = serviceContainer.addService(ActiveMQActivationService.getServiceName(JMSService.this.serverServiceName), (Service)new ActiveMQActivationService()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    } else {
                        this.activeMQActivationController.setMode(ServiceController.Mode.ACTIVE);
                    }
                }

                public void activationComplete() {
                }

                public void deActivate() {
                    if (this.activeMQActivationController != null && !this.activeMQActivationController.getState().in(new ServiceController.State[]{ServiceController.State.STOPPING, ServiceController.State.REMOVED})) {
                        final CountDownLatch latch = new CountDownLatch(1);
                        this.activeMQActivationController.compareAndSetMode(ServiceController.Mode.ACTIVE, ServiceController.Mode.REMOVE);
                        this.activeMQActivationController.addListener(new LifecycleListener(){

                            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                                if (event == LifecycleEvent.REMOVED) {
                                    latch.countDown();
                                }
                            }
                        });
                        try {
                            latch.await(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.activeMQActivationController = null;
                    }
                }
            });
            this.jmsServer.start();
        }
        catch (StartException e2) {
            throw e2;
        }
        catch (Throwable t) {
            throw new StartException(t);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    private synchronized void doStop(StopContext context) {
        try {
            this.jmsServer.stop();
            this.jmsServer = null;
        }
        catch (Exception e) {
            MessagingLogger.ROOT_LOGGER.errorStoppingJmsServer(e);
        }
    }
}

