/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.BackupReceiverRepository;
import org.infinispan.xsite.XSiteReplicateCommand;

@Scope(value=Scopes.GLOBAL)
public class GlobalInboundInvocationHandler
implements InboundInvocationHandler {
    private static final Log log = LogFactory.getLog(GlobalInboundInvocationHandler.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    @ComponentName(value="org.infinispan.executors.remote")
    private ExecutorService remoteCommandsExecutor;
    @Inject
    private BackupReceiverRepository backupReceiverRepository;
    @Inject
    private GlobalComponentRegistry globalComponentRegistry;

    private static Response shuttingDownResponse() {
        return CacheNotFoundResponse.INSTANCE;
    }

    private static ExceptionResponse exceptionHandlingCommand(Throwable throwable) {
        return new ExceptionResponse((Exception)((Object)new CacheException("Problems invoking command.", throwable)));
    }

    @Override
    public void handleFromCluster(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
        command.setOrigin(origin);
        try {
            if (command.getCommandId() == 30) {
                reply.reply(null);
            } else if (command instanceof CacheRpcCommand) {
                this.handleCacheRpcCommand(origin, (CacheRpcCommand)command, reply, order);
            } else {
                this.handleReplicableCommand(origin, command, reply, order);
            }
        }
        catch (Throwable t) {
            log.exceptionHandlingCommand(command, t);
            reply.reply(GlobalInboundInvocationHandler.exceptionHandlingCommand(t));
        }
    }

    @Override
    public void handleFromRemoteSite(String origin, XSiteReplicateCommand command, Reply reply, DeliverOrder order) {
        BackupReceiver receiver;
        ComponentRegistry cr;
        PerCacheInboundInvocationHandler handler;
        if (trace) {
            log.tracef("Handling command %s from remote site %s", command, origin);
        }
        if ((handler = (cr = (receiver = this.backupReceiverRepository.getBackupReceiver(origin, command.getCacheName().toString())).getCache().getAdvancedCache().getComponentRegistry()).getPerCacheInboundInvocationHandler()) != null) {
            handler.registerXSiteCommandReceiver(reply != Reply.NO_OP);
        }
        command.performInLocalSite(receiver, order.preserveOrder()).whenComplete(new ResponseConsumer(command, reply));
    }

    private void handleCacheRpcCommand(Address origin, CacheRpcCommand command, Reply reply, DeliverOrder mode) {
        ByteString cacheName;
        ComponentRegistry cr;
        if (trace) {
            log.tracef("Attempting to execute CacheRpcCommand: %s [sender=%s]", command, origin);
        }
        if ((cr = this.globalComponentRegistry.getNamedComponentRegistry(cacheName = command.getCacheName())) == null) {
            if (trace) {
                log.tracef("Silently ignoring that %s cache is not defined", cacheName);
            }
            reply.reply(CacheNotFoundResponse.INSTANCE);
            return;
        }
        this.initializeCacheRpcCommand(command, cr);
        PerCacheInboundInvocationHandler handler = cr.getPerCacheInboundInvocationHandler();
        handler.handle(command, reply, mode);
    }

    private void initializeCacheRpcCommand(CacheRpcCommand command, ComponentRegistry componentRegistry) {
        CommandsFactory commandsFactory = componentRegistry.getCommandsFactory();
        commandsFactory.initializeReplicableCommand(command, true);
    }

    private void handleReplicableCommand(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
        if (trace) {
            log.tracef("Attempting to execute non-CacheRpcCommand: %s [sender=%s]", command, origin);
        }
        ReplicableCommandRunner runnable = new ReplicableCommandRunner(command, reply, this.globalComponentRegistry, order.preserveOrder());
        if (order.preserveOrder() || !command.canBlock()) {
            runnable.run();
        } else {
            this.remoteCommandsExecutor.execute(runnable);
        }
    }

    private static class ResponseConsumer
    implements BiConsumer<Object, Throwable> {
        final ReplicableCommand command;
        private final Reply reply;

        private ResponseConsumer(ReplicableCommand command, Reply reply) {
            this.command = command;
            this.reply = reply;
        }

        @Override
        public void accept(Object retVal, Throwable throwable) {
            this.reply.reply(this.convertToResponse(retVal, throwable));
        }

        private Response convertToResponse(Object retVal, Throwable throwable) {
            if (throwable != null) {
                if ((throwable = CompletableFutures.extractException(throwable)) instanceof InterruptedException || throwable instanceof IllegalLifecycleStateException) {
                    log.debugf("Shutdown while handling command %s", this.command);
                    return GlobalInboundInvocationHandler.shuttingDownResponse();
                }
                log.exceptionHandlingCommand(this.command, throwable);
                return GlobalInboundInvocationHandler.exceptionHandlingCommand(throwable);
            }
            if (retVal == null || retVal instanceof Response) {
                return (Response)retVal;
            }
            return SuccessfulResponse.create(retVal);
        }
    }

    private static class ReplicableCommandRunner
    extends ResponseConsumer
    implements Runnable {
        private final GlobalComponentRegistry globalComponentRegistry;
        private final boolean preserveOrder;

        private ReplicableCommandRunner(ReplicableCommand command, Reply reply, GlobalComponentRegistry globalComponentRegistry, boolean preserveOrder) {
            super(command, reply);
            this.globalComponentRegistry = globalComponentRegistry;
            this.preserveOrder = preserveOrder;
        }

        @Override
        public void run() {
            try {
                this.globalComponentRegistry.wireDependencies(this.command);
                CompletionStage future = this.command.invokeAsync().whenComplete((BiConsumer)this);
                if (this.preserveOrder) {
                    ((CompletableFuture)future).join();
                }
            }
            catch (Throwable throwable) {
                this.accept((Object)null, throwable);
            }
        }
    }
}

