/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Role;

public class CacheRoleImpl
implements Role {
    private final String name;
    private final Set<AuthorizationPermission> permissions;
    private final int mask;

    public CacheRoleImpl(String name, AuthorizationPermission ... authorizationPermissions) {
        this(name, new HashSet<AuthorizationPermission>(Arrays.asList(authorizationPermissions)));
    }

    public CacheRoleImpl(String name, Set<AuthorizationPermission> permissions) {
        this.name = name;
        this.permissions = Collections.unmodifiableSet(permissions);
        int permMask = 0;
        for (AuthorizationPermission permission : permissions) {
            permMask |= permission.getMask();
        }
        this.mask = permMask;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<AuthorizationPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    public String toString() {
        return "CacheRoleImpl [name=" + this.name + ", permissions=" + this.permissions + ", mask=" + this.mask + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheRoleImpl cacheRole = (CacheRoleImpl)o;
        if (this.mask != cacheRole.mask) {
            return false;
        }
        if (!this.name.equals(cacheRole.name)) {
            return false;
        }
        return this.permissions.equals(cacheRole.permissions);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.permissions.hashCode();
        result = 31 * result + this.mask;
        return result;
    }
}

