/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.Cache;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetClusterExecutorAction;
import org.infinispan.security.impl.SecureCacheImpl;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static ClusterExecutor getClusterExecutor(Cache<?, ?> cache) {
        GetClusterExecutorAction action = new GetClusterExecutorAction(cache);
        return SecurityActions.doPrivileged(action);
    }

    static ClusterExecutor getClusterExecutor(EmbeddedCacheManager cacheManager) {
        GetClusterExecutorAction action = new GetClusterExecutorAction(cacheManager);
        return SecurityActions.doPrivileged(action);
    }

    static <K, V> Cache<K, V> getUnwrappedCache(Cache<K, V> cache) {
        if (cache instanceof SecureCacheImpl) {
            return SecurityActions.doPrivileged(() -> ((SecureCacheImpl)cache).getDelegate());
        }
        return cache;
    }
}

