/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;

class KeyWatchingCompletionListener {
    private AtomicReference<Object> currentKey = new AtomicReference();
    private final Consumer<? super Supplier<PrimitiveIterator.OfInt>> completionListener;
    private final Map<Object, Supplier<PrimitiveIterator.OfInt>> pendingSegments = new ConcurrentHashMap<Object, Supplier<PrimitiveIterator.OfInt>>();

    KeyWatchingCompletionListener(Consumer<? super Supplier<PrimitiveIterator.OfInt>> completionListener) {
        this.completionListener = completionListener;
    }

    public void valueAdded(Object key) {
        this.currentKey.set(key);
    }

    public void accept(Supplier<PrimitiveIterator.OfInt> segments) {
        Supplier<PrimitiveIterator.OfInt> notifyThese;
        Object key = this.currentKey.get();
        if (key != null) {
            this.pendingSegments.put(key, segments);
            notifyThese = this.currentKey.getAndSet(null) == null ? this.pendingSegments.remove(key) : null;
        } else {
            notifyThese = segments;
        }
        if (notifyThese != null) {
            this.completionListener.accept(notifyThese);
        }
    }

    public void valueIterated(Object key) {
        Supplier<PrimitiveIterator.OfInt> segments;
        if (!this.currentKey.compareAndSet(key, null) && (segments = this.pendingSegments.remove(key)) != null) {
            this.completionListener.accept(segments);
        }
    }

    public void completed() {
        assert (this.pendingSegments.isEmpty()) : "pendingSegments should be empty but was: " + this.pendingSegments;
    }
}

