/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import org.jboss.as.network.ClientMapping;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;

public class ClientMappingExternalizer
implements Externalizer<ClientMapping> {
    public void writeObject(ObjectOutput output, ClientMapping mapping) throws IOException {
        byte[] address = mapping.getSourceNetworkAddress().getAddress();
        IndexSerializer.UNSIGNED_BYTE.writeInt((DataOutput)output, address.length);
        output.write(address);
        IndexSerializer.UNSIGNED_BYTE.writeInt((DataOutput)output, mapping.getSourceNetworkMaskBits());
        output.writeUTF(mapping.getDestinationAddress());
        IndexSerializer.UNSIGNED_SHORT.writeInt((DataOutput)output, mapping.getDestinationPort());
    }

    public ClientMapping readObject(ObjectInput input) throws IOException {
        byte[] sourceAddress = new byte[IndexSerializer.UNSIGNED_BYTE.readInt((DataInput)input)];
        input.readFully(sourceAddress);
        int sourceNetworkMaskBits = IndexSerializer.UNSIGNED_BYTE.readInt((DataInput)input);
        String destAddress = input.readUTF();
        int destPort = IndexSerializer.UNSIGNED_SHORT.readInt((DataInput)input);
        return new ClientMapping(InetAddress.getByAddress(sourceAddress), sourceNetworkMaskBits, destAddress, destPort);
    }

    public Class<ClientMapping> getTargetClass() {
        return ClientMapping.class;
    }
}

