/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.concurrent;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.concurrent.Callable;

public class TracedCallable<V>
implements Callable<V> {
    private final Callable<V> delegate;
    private final Span span;
    private final Tracer tracer;

    public TracedCallable(Callable<V> delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.span = tracer.activeSpan();
    }

    @Override
    public V call() throws Exception {
        Scope scope = this.span == null ? null : this.tracer.scopeManager().activate(this.span, false);
        try {
            V v = this.delegate.call();
            return v;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }
}

