/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.aspect;

import javax.xml.ws.spi.Provider;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.Configurer;
import org.jboss.ws.api.binding.BindingCustomization;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.ResourceResolver;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSBusFactory;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.deployment.aspect.SecurityActions;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;
import org.jboss.wsf.stack.cxf.resolver.JBossWSResourceResolver;

public final class BusDeploymentAspect
extends AbstractDeploymentAspect {
    public void start(Deployment dep) {
        if (BusFactory.getDefaultBus((boolean)false) == null) {
            JBossWSBusFactory.getDefaultBus((ClassLoader)Provider.provider().getClass().getClassLoader());
        }
        this.startDeploymentBus(dep);
    }

    public void stop(Deployment dep) {
        BusHolder holder = (BusHolder)dep.removeAttachment(BusHolder.class);
        if (holder != null) {
            holder.close();
            WSDLFilePublisher wsdlFilePublisher = (WSDLFilePublisher)((Object)dep.getAttachment(WSDLFilePublisher.class));
            if (wsdlFilePublisher != null) {
                wsdlFilePublisher.unpublishWsdlFiles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDeploymentBus(Deployment dep) {
        BusFactory.setThreadDefaultBus(null);
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        try {
            ArchiveDeployment aDep = (ArchiveDeployment)dep;
            ResourceResolver deploymentResolver = aDep.getResourceResolver();
            JBossWSResourceResolver resolver = new JBossWSResourceResolver(deploymentResolver);
            SecurityActions.setContextClassLoader((ClassLoader)new DelegateClassLoader(dep.getClassLoader(), origClassLoader));
            DDBeans metadata = (DDBeans)dep.getAttachment(DDBeans.class);
            BusHolder holder = new BusHolder(metadata);
            Configurer configurer = holder.createServerConfigurer((BindingCustomization)dep.getAttachment(BindingCustomization.class), new WSDLFilePublisher(aDep), aDep);
            holder.configure(resolver, configurer, (JBossWebservicesMetaData)dep.getAttachment(JBossWebservicesMetaData.class), dep);
            dep.addAttachment(BusHolder.class, (Object)holder);
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
            SecurityActions.setContextClassLoader(origClassLoader);
        }
    }
}

