/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.auth.principal.DefaultJWTCallerPrincipalFactory;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import io.smallrye.jwt.auth.principal.ParseException;
import java.net.URL;
import java.security.AccessController;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;

public abstract class JWTCallerPrincipalFactory {
    private static final Logger LOGGER = Logger.getLogger(JWTCallerPrincipalFactory.class);
    private static volatile JWTCallerPrincipalFactory instance;

    public static JWTCallerPrincipalFactory instance() {
        JWTCallerPrincipalFactory newInstance;
        if (instance != null) {
            return instance;
        }
        ClassLoader cl = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        if (cl == null) {
            cl = JWTCallerPrincipalFactory.class.getClassLoader();
        }
        if ((newInstance = JWTCallerPrincipalFactory.loadSpi(cl)) == null && cl != JWTCallerPrincipalFactory.class.getClassLoader()) {
            cl = JWTCallerPrincipalFactory.class.getClassLoader();
            newInstance = JWTCallerPrincipalFactory.loadSpi(cl);
        }
        if (newInstance == null) {
            newInstance = new DefaultJWTCallerPrincipalFactory();
        }
        return newInstance;
    }

    private static JWTCallerPrincipalFactory loadSpi(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        JWTCallerPrincipalFactory instance = JWTCallerPrincipalFactory.loadSpi(cl.getParent());
        if (instance == null) {
            ServiceLoader<JWTCallerPrincipalFactory> sl = ServiceLoader.load(JWTCallerPrincipalFactory.class, cl);
            URL u = cl.getResource("/META-INF/services/org.eclipse.microprofile.jwt.principal.JWTCallerPrincipalFactory");
            LOGGER.debugf("loadSpi, cl=%s, u=%s, sl=%s", (Object)cl, (Object)u, sl);
            try {
                for (JWTCallerPrincipalFactory spi : sl) {
                    if (instance != null) {
                        LOGGER.warn((Object)("Multiple JWTCallerPrincipalFactory implementations found: " + spi.getClass().getName() + " and " + instance.getClass().getName()));
                        break;
                    }
                    LOGGER.debugf("sl=%s, loaded=%s", sl, (Object)spi);
                    instance = spi;
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Failed to locate JWTCallerPrincipalFactory provider", (Throwable)e);
            }
        }
        return instance;
    }

    public static synchronized void setInstance(JWTCallerPrincipalFactory resolver) {
        instance = resolver;
    }

    public abstract JWTCallerPrincipal parse(String var1, JWTAuthContextInfo var2) throws ParseException;
}

