/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.threads.Messages;
import org.wildfly.common.Assert;

public final class AtomicArray<T, V> {
    private final AtomicReferenceFieldUpdater<T, V[]> updater;
    private final V[] emptyArray;

    private AtomicArray(AtomicReferenceFieldUpdater<T, V[]> updater, V[] emptyArray) {
        this.updater = updater;
        this.emptyArray = emptyArray;
    }

    public static <T, V> AtomicArray<T, V> create(AtomicReferenceFieldUpdater<T, V[]> updater, Class<V> componentType) {
        Assert.checkNotNullParam((String)"updater", updater);
        Assert.checkNotNullParam((String)"componentType", componentType);
        return new AtomicArray<T, Object>(updater, (Object[])Array.newInstance(componentType, 0));
    }

    @Deprecated
    public static <T, V> AtomicArray<T, V> create(AtomicReferenceFieldUpdater<T, V[]> updater, Creator<V> creator) {
        Assert.checkNotNullParam((String)"updater", updater);
        Assert.checkNotNullParam((String)"creator", creator);
        return new AtomicArray<T, V>(updater, creator.create(0));
    }

    public static <T, V> AtomicArray<T, V> create(AtomicReferenceFieldUpdater<T, V[]> updater, V[] emptyArray) {
        Assert.checkNotNullParam((String)"updater", updater);
        Assert.checkNotNullParam((String)"emptyArray", emptyArray);
        if (emptyArray.length > 0) {
            throw Messages.msg.arrayNotEmpty();
        }
        return new AtomicArray<T, V>(updater, emptyArray);
    }

    public void clear(T instance) {
        this.updater.set(instance, (V[][])this.emptyArray);
    }

    public void set(T instance, V[] value) {
        this.updater.set(instance, (V[][])value);
    }

    public V[] getAndSet(T instance, V[] value) {
        return this.updater.getAndSet(instance, (V[][])value);
    }

    public void add(T instance, V value) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            oldVal = updater.get(instance);
            int oldLen = oldVal.length;
            newVal = Arrays.copyOf(oldVal, oldLen + 1);
            newVal[oldLen] = value;
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
    }

    public boolean addIfAbsent(T instance, V value, boolean identity) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            int i;
            oldVal = updater.get(instance);
            int oldLen = oldVal.length;
            if (identity || value == null) {
                for (i = 0; i < oldLen; ++i) {
                    if (oldVal[i] != value) continue;
                    return false;
                }
            } else {
                for (i = 0; i < oldLen; ++i) {
                    if (!value.equals(oldVal[i])) continue;
                    return false;
                }
            }
            newVal = Arrays.copyOf(oldVal, oldLen + 1);
            newVal[oldLen] = value;
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return true;
    }

    public boolean remove(T instance, V value, boolean identity) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            int i;
            int oldLen;
            if ((oldLen = (oldVal = updater.get(instance)).length) == 0) {
                return false;
            }
            int index = -1;
            if (identity || value == null) {
                for (i = 0; i < oldLen; ++i) {
                    if (oldVal[i] != value) continue;
                    index = i;
                    break;
                }
            } else {
                for (i = 0; i < oldLen; ++i) {
                    if (!value.equals(oldVal[i])) continue;
                    index = i;
                    break;
                }
            }
            if (index == -1) {
                return false;
            }
            newVal = Arrays.copyOf(oldVal, oldLen - 1);
            System.arraycopy(oldVal, index + 1, newVal, index, oldLen - index - 1);
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return true;
    }

    public int removeAll(T instance, V value, boolean identity) {
        int removeCount;
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            int i;
            int oldLen;
            if ((oldLen = (oldVal = updater.get(instance)).length) == 0) {
                return 0;
            }
            boolean[] removeSlots = new boolean[oldLen];
            removeCount = 0;
            if (identity || value == null) {
                for (i = 0; i < oldLen; ++i) {
                    if (oldVal[i] != value) continue;
                    removeSlots[i] = true;
                    ++removeCount;
                }
            } else {
                for (i = 0; i < oldLen; ++i) {
                    if (!value.equals(oldVal[i])) continue;
                    removeSlots[i] = true;
                    ++removeCount;
                }
            }
            if (removeCount == 0) {
                return 0;
            }
            int newLen = oldLen - removeCount;
            if (newLen == 0) {
                newVal = this.emptyArray;
                continue;
            }
            newVal = Arrays.copyOf(this.emptyArray, newLen);
            int j = 0;
            for (int i2 = 0; i2 < oldLen; ++i2) {
                if (removeSlots[i2]) continue;
                newVal[j++] = oldVal[i2];
            }
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return removeCount;
    }

    public void add(T instance, V value, Comparator<? super V> comparator) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            oldVal = updater.get(instance);
            int oldLen = oldVal.length;
            int pos = AtomicArray.insertionPoint(Arrays.binarySearch(oldVal, value, comparator));
            newVal = Arrays.copyOf(oldVal, oldLen + 1);
            newVal[pos] = value;
            System.arraycopy(oldVal, pos, newVal, pos + 1, oldLen - pos);
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
    }

    public boolean addIfAbsent(T instance, V value, Comparator<? super V> comparator) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            oldVal = updater.get(instance);
            int oldLen = oldVal.length;
            int pos = Arrays.binarySearch(oldVal, value, comparator);
            if (pos < 0) {
                return false;
            }
            newVal = Arrays.copyOf(oldVal, oldLen + 1);
            newVal[pos] = value;
            System.arraycopy(oldVal, pos, newVal, pos + 1, oldLen - pos);
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return true;
    }

    public boolean remove(T instance, V value, Comparator<? super V> comparator) {
        V[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, V[][]> updater = this.updater;
        do {
            int oldLen;
            if ((oldLen = (oldVal = updater.get(instance)).length) == 0) {
                return false;
            }
            int pos = Arrays.binarySearch(oldVal, value, comparator);
            if (pos < 0) {
                return false;
            }
            newVal = Arrays.copyOf(oldVal, oldLen - 1);
            System.arraycopy(oldVal, pos + 1, newVal, pos, oldLen - pos - 1);
        } while (!updater.compareAndSet(instance, (V[][])oldVal, (V[][])newVal));
        return true;
    }

    public void sort(T instance, Comparator<? super V> comparator) {
        Object[] newVal;
        V[] oldVal;
        AtomicReferenceFieldUpdater<T, Object[][]> updater = this.updater;
        do {
            if ((oldVal = updater.get(instance)).length == 0) {
                return;
            }
            newVal = (Object[])oldVal.clone();
            Arrays.sort(newVal, comparator);
        } while (!updater.compareAndSet(instance, (Object[][])oldVal, (Object[][])newVal));
    }

    private static int insertionPoint(int searchResult) {
        return searchResult > 0 ? searchResult : -(searchResult + 1);
    }

    @Deprecated
    public static interface Creator<V> {
        public V[] create(int var1);
    }
}

