/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.dmr.ModelNode;

class RemotingEndpointRemove
extends ModelOnlyRemoveStepHandler {
    RemotingEndpointRemove() {
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress parentAddress = context.getCurrentAddress().getParent();
        ModelNode parentModel = context.readResourceFromRoot(parentAddress, false).getModel();
        OperationStepHandler writeHandler = null;
        ModelNode baseWriteOp = null;
        for (AttributeDefinition ad : RemotingEndpointResource.ATTRIBUTES.values()) {
            String attr = ad.getName();
            if (!parentModel.hasDefined(attr)) continue;
            if (writeHandler == null) {
                writeHandler = context.getRootResourceRegistration().getOperationHandler(parentAddress, "write-attribute");
                baseWriteOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)parentAddress);
            }
            ModelNode writeOp = baseWriteOp.clone();
            writeOp.get("name").set(attr);
            writeOp.get("value").set(new ModelNode());
            context.addStep(writeOp, writeHandler, OperationContext.Stage.MODEL, true);
        }
    }
}

