/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting;

import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import java.security.Principal;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;

public class CertificateUtil {
    public static X509Certificate[] getCertsFromConnection(RemotingConnection remotingConnection) {
        Connection transportConnection;
        X509Certificate[] certificates = null;
        if (remotingConnection != null && (transportConnection = remotingConnection.getTransportConnection()) instanceof NettyConnection) {
            certificates = org.apache.activemq.artemis.utils.CertificateUtil.getCertsFromChannel(((NettyConnection)transportConnection).getChannel());
        }
        return certificates;
    }

    public static Principal getPeerPrincipalFromConnection(RemotingConnection remotingConnection) {
        NettyConnection nettyConnection;
        ChannelHandler channelHandler;
        Connection transportConnection;
        Principal result = null;
        if (remotingConnection != null && (transportConnection = remotingConnection.getTransportConnection()) instanceof NettyConnection && (channelHandler = (nettyConnection = (NettyConnection)transportConnection).getChannel().pipeline().get("ssl")) != null && channelHandler instanceof SslHandler) {
            SslHandler sslHandler = (SslHandler)channelHandler;
            try {
                result = sslHandler.engine().getSession().getPeerPrincipal();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return result;
    }
}

