/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolConfigurationServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.SingletonProtocolServiceNameProvider;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jgroups.JChannel;
import org.jgroups.protocols.FORK;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.RemoteSiteConfiguration;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class RelayConfigurationServiceConfigurator
extends AbstractProtocolConfigurationServiceConfigurator<RELAY2, RelayConfiguration>
implements RelayConfiguration {
    private final ServiceNameProvider provider;
    private volatile List<SupplierDependency<RemoteSiteConfiguration>> sites;
    private volatile String siteName = null;

    public RelayConfigurationServiceConfigurator(PathAddress address) {
        super(address.getLastElement().getValue());
        this.provider = new SingletonProtocolServiceNameProvider(address);
    }

    public ServiceName getServiceName() {
        return this.provider.getServiceName();
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        for (Dependency dependency : this.sites) {
            dependency.register(builder);
        }
        return super.register(builder);
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.siteName = RelayResourceDefinition.Attribute.SITE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        PathAddress address = context.getCurrentAddress();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        Set entries = resource.getChildren(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey());
        this.sites = new ArrayList<SupplierDependency<RemoteSiteConfiguration>>(entries.size());
        for (Resource.ResourceEntry entry : entries) {
            this.sites.add((SupplierDependency<RemoteSiteConfiguration>)new ServiceSupplierDependency((ServiceNameProvider)new RemoteSiteServiceNameProvider(address, entry.getPathElement())));
        }
        return super.configure(context, model);
    }

    @Override
    public RelayConfiguration get() {
        return this;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public List<RemoteSiteConfiguration> getRemoteSites() {
        ArrayList<RemoteSiteConfiguration> result = new ArrayList<RemoteSiteConfiguration>(this.sites.size());
        for (Supplier supplier : this.sites) {
            result.add((RemoteSiteConfiguration)supplier.get());
        }
        return result;
    }

    @Override
    public void accept(RELAY2 protocol) {
        String localSite = this.siteName;
        List<RemoteSiteConfiguration> remoteSites = this.getRemoteSites();
        ArrayList<String> sites = new ArrayList<String>(remoteSites.size() + 1);
        sites.add(localSite);
        HashMap<String, 1> bridges = new HashMap<String, 1>();
        for (final RemoteSiteConfiguration remoteSite : remoteSites) {
            final String siteName = remoteSite.getName();
            sites.add(siteName);
            String clusterName = remoteSite.getClusterName();
            RelayConfig.BridgeConfig bridge = new RelayConfig.BridgeConfig(clusterName){

                public JChannel createChannel() throws Exception {
                    JChannel channel = remoteSite.getChannelFactory().createChannel(siteName);
                    channel.getProtocolStack().removeProtocol(FORK.class);
                    return channel;
                }
            };
            bridges.put(clusterName, bridge);
        }
        protocol.site(localSite);
        for (String site : sites) {
            RelayConfig.SiteConfig siteConfig = new RelayConfig.SiteConfig(site);
            protocol.addSite(site, siteConfig);
            if (!site.equals(localSite)) continue;
            for (RelayConfig.BridgeConfig bridge : bridges.values()) {
                siteConfig.addBridge(bridge);
            }
        }
    }
}

