/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.ejb.client.AttachmentKey;
import org.wildfly.common.Assert;

public abstract class Attachable {
    private final Map<AttachmentKey<?>, Object> attachments;

    private Attachable(Map<AttachmentKey<?>, Object> attachments) {
        this.attachments = attachments;
    }

    Attachable() {
        this(new IdentityHashMap());
    }

    Attachable(Attachable attachable) {
        this(attachable.attachments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAttachment(AttachmentKey<T> key) {
        Map<AttachmentKey<?>, Object> attachments;
        if (key == null) {
            return null;
        }
        Map<AttachmentKey<?>, Object> map = attachments = this.attachments;
        synchronized (map) {
            return (T)attachments.get(key);
        }
    }

    public Map<AttachmentKey<?>, ?> getAttachments() {
        if (this.attachments == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attachments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        Map<AttachmentKey<?>, Object> attachments;
        Assert.checkNotNullParam((String)"key", key);
        Assert.checkNotNullParam((String)"value", value);
        Map<AttachmentKey<?>, Object> map = attachments = this.attachments;
        synchronized (map) {
            return (T)attachments.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T putAttachmentIfAbsent(AttachmentKey<T> key, T value) {
        Map<AttachmentKey<?>, Object> attachments;
        Assert.checkNotNullParam((String)"key", key);
        Assert.checkNotNullParam((String)"value", value);
        Map<AttachmentKey<?>, Object> map = attachments = this.attachments;
        synchronized (map) {
            return (T)(attachments.containsKey(key) ? attachments.get(key) : attachments.put(key, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T replaceAttachment(AttachmentKey<T> key, T value) {
        Map<AttachmentKey<?>, Object> attachments;
        if (key == null) {
            return null;
        }
        Assert.checkNotNullParam((String)"value", value);
        Map<AttachmentKey<?>, Object> map = attachments = this.attachments;
        synchronized (map) {
            return (T)(attachments.containsKey(key) ? attachments.put(key, value) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean replaceAttachment(AttachmentKey<T> key, T oldValue, T newValue) {
        Map<AttachmentKey<?>, Object> attachments;
        if (key == null) {
            return false;
        }
        if (oldValue == null) {
            return false;
        }
        Assert.checkNotNullParam((String)"newValue", newValue);
        Map<AttachmentKey<?>, Object> map = attachments = this.attachments;
        synchronized (map) {
            Object lhs = attachments.get(key);
            return attachments.containsKey(key) && oldValue.equals(lhs) && attachments.put(key, newValue) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T removeAttachment(AttachmentKey<T> key) {
        Map<AttachmentKey<?>, Object> attachments;
        if (key == null) {
            return null;
        }
        Map<AttachmentKey<?>, Object> map = attachments = this.attachments;
        synchronized (map) {
            return (T)attachments.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean removeAttachment(AttachmentKey<T> key, T value) {
        Map<AttachmentKey<?>, Object> attachments;
        if (key == null) {
            return false;
        }
        if (value == null) {
            return false;
        }
        Map<AttachmentKey<?>, Object> map = attachments = this.attachments;
        synchronized (map) {
            Object lhs = attachments.get(key);
            return attachments.containsKey(key) && value.equals(lhs) && attachments.remove(key) != null;
        }
    }

    void clearAttachments() {
        this.attachments.clear();
    }
}

