/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.routing;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.ServiceNameFactory;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameRegistry;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.CacheServiceConfiguratorProvider;
import org.wildfly.clustering.spi.DistributedCacheServiceConfiguratorProvider;
import org.wildfly.clustering.web.cache.routing.LocalRouteServiceConfigurator;
import org.wildfly.clustering.web.infinispan.routing.InfinispanRoutingConfiguration;
import org.wildfly.clustering.web.infinispan.routing.RouteRegistryEntryProviderServiceConfigurator;
import org.wildfly.clustering.web.routing.RoutingProvider;

public class InfinispanRoutingProvider
implements RoutingProvider {
    private final InfinispanRoutingConfiguration config;

    public InfinispanRoutingProvider(InfinispanRoutingConfiguration config) {
        this.config = config;
    }

    public Collection<CapabilityServiceConfigurator> getServiceConfigurators(String serverName, SupplierDependency<String> route) {
        String containerName = this.config.getContainerName();
        String cacheName = this.config.getCacheName();
        LinkedList<CapabilityServiceConfigurator> builders = new LinkedList<CapabilityServiceConfigurator>();
        builders.add((CapabilityServiceConfigurator)new LocalRouteServiceConfigurator(serverName, route));
        builders.add(new RouteRegistryEntryProviderServiceConfigurator(containerName, serverName));
        builders.add((CapabilityServiceConfigurator)new TemplateConfigurationServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, serverName)), containerName, serverName, cacheName, (Consumer)this.config));
        builders.add((CapabilityServiceConfigurator)new CacheServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CACHE.resolve(containerName, serverName)), containerName, serverName));
        ServiceNameRegistry registry = requirement -> ServiceNameFactory.parseServiceName((String)requirement.resolve(containerName, serverName));
        for (CacheServiceConfiguratorProvider cacheServiceConfiguratorProvider : ServiceLoader.load(DistributedCacheServiceConfiguratorProvider.class, DistributedCacheServiceConfiguratorProvider.class.getClassLoader())) {
            builders.addAll(cacheServiceConfiguratorProvider.getServiceConfigurators(registry, containerName, serverName));
        }
        return builders;
    }
}

