/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.dmr.ModelNode;

class PathWriteAttributeHandler
extends AbstractWriteAttributeHandler<PathUpdate> {
    private final PathManagerService pathManager;

    PathWriteAttributeHandler(PathManagerService pathManager, SimpleAttributeDefinition definition) {
        super(definition);
        this.pathManager = pathManager;
    }

    @Override
    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        PathEntry pathEntry;
        String pathName = context.getCurrentAddressValue();
        if (model.getModel().get(PathResourceDefinition.READ_ONLY.getName()).asBoolean(false)) {
            throw ControllerLogger.ROOT_LOGGER.cannotModifyReadOnlyPath(pathName);
        }
        if (this.pathManager != null && (pathEntry = this.pathManager.getPathEntry(pathName)).isReadOnly()) {
            throw ControllerLogger.ROOT_LOGGER.pathEntryIsReadOnly(operation.require("address").asString());
        }
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return this.pathManager != null;
    }

    @Override
    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<PathUpdate> handbackHolder) throws OperationFailedException {
        String pathName = context.getCurrentAddressValue();
        PathEntry pathEntry = this.pathManager.getPathEntry(pathName);
        PathEntry backup = new PathEntry(pathEntry);
        PathManagerService.PathEventContextImpl pathEventContext = this.pathManager.checkRestartRequired(context, pathName, PathManager.Event.UPDATED);
        if (pathEventContext.isInstallServices()) {
            if (attributeName.equals("path")) {
                String pathVal = resolvedValue.asString();
                this.pathManager.changePath(pathName, pathVal);
                this.pathManager.changePathServices(context, pathName, pathVal);
            } else if (attributeName.equals("relative-to")) {
                String relToVal = resolvedValue.isDefined() ? resolvedValue.asString() : null;
                this.pathManager.changeRelativePath(pathName, relToVal, true);
                this.pathManager.changeRelativePathServices(context, pathName, relToVal);
            }
        }
        handbackHolder.setHandback(new PathUpdate(backup, pathEventContext));
        return false;
    }

    @Override
    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, PathUpdate handback) throws OperationFailedException {
        String pathName = context.getCurrentAddressValue();
        PathEntry backup = handback.backup;
        PathManagerService.PathEventContextImpl pathEventContext = handback.context;
        if (pathEventContext.isInstallServices()) {
            if (attributeName.equals("path")) {
                this.pathManager.changePath(pathName, backup.getPath());
                this.pathManager.changePathServices(context, pathName, valueToRestore.asString());
            } else if (attributeName.equals("relative-to")) {
                try {
                    this.pathManager.changeRelativePath(pathName, backup.getRelativeTo(), false);
                }
                catch (OperationFailedException e) {
                    throw new RuntimeException(e);
                }
                this.pathManager.changeRelativePathServices(context, pathName, valueToRestore.isDefined() ? valueToRestore.asString() : null);
            }
        } else {
            pathEventContext.revert();
        }
    }

    static class PathUpdate {
        private final PathEntry backup;
        private final PathManagerService.PathEventContextImpl context;

        private PathUpdate(PathEntry backup, PathManagerService.PathEventContextImpl context) {
            this.backup = backup;
            this.context = context;
        }
    }
}

