/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.smallrye.health.ResponseProvider;
import io.smallrye.health.SmallRyeHealthReporter;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.health.HealthReporter;

public class HealthReporterService
implements Service<HealthReporter> {
    private static HealthReporter healthReporter;
    private String emptyLivenessChecksStatus;
    private String emptyReadinessChecksStatus;

    static void install(OperationContext context, String emptyLivenessChecksStatus, String emptyReadinessChecksStatus) {
        context.getCapabilityServiceTarget().addCapability(RuntimeCapability.Builder.of((String)"org.wildfly.microprofile.health.reporter", SmallRyeHealthReporter.class).build()).setInstance((org.jboss.msc.Service)new HealthReporterService(emptyLivenessChecksStatus, emptyReadinessChecksStatus)).install();
    }

    private HealthReporterService(String emptyLivenessChecksStatus, String emptyReadinessChecksStatus) {
        this.emptyLivenessChecksStatus = emptyLivenessChecksStatus;
        this.emptyReadinessChecksStatus = emptyReadinessChecksStatus;
    }

    public void start(StartContext context) {
        healthReporter = new HealthReporter(this.emptyLivenessChecksStatus, this.emptyReadinessChecksStatus);
        HealthCheckResponse.setResponseProvider((HealthCheckResponseProvider)new ResponseProvider());
    }

    public void stop(StopContext context) {
        healthReporter = null;
        HealthCheckResponse.setResponseProvider(null);
    }

    public HealthReporter getValue() {
        return healthReporter;
    }
}

