/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.OpenApiParser;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import java.io.IOException;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.OASModelReader;
import org.jboss.jandex.IndexView;

public class OpenApiProcessor {
    public static OpenAPIImpl modelFromStaticFile(OpenApiStaticFile staticFile) {
        if (staticFile == null) {
            return null;
        }
        try {
            return OpenApiParser.parse(staticFile.getContent(), staticFile.getFormat());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OpenAPIImpl modelFromAnnotations(OpenApiConfig config, IndexView index) {
        if (config.scanDisable()) {
            return null;
        }
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(config, index);
        return scanner.scan();
    }

    public static OpenAPIImpl modelFromReader(OpenApiConfig config, ClassLoader loader) {
        String readerClassName = config.modelReader();
        if (readerClassName == null) {
            return null;
        }
        try {
            Class<?> c = loader.loadClass(readerClassName);
            OASModelReader reader = (OASModelReader)c.newInstance();
            return (OpenAPIImpl)reader.buildModel();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static OASFilter getFilter(OpenApiConfig config, ClassLoader loader) {
        String filterClassName = config.filter();
        if (filterClassName == null) {
            return null;
        }
        try {
            Class<?> c = loader.loadClass(filterClassName);
            return (OASFilter)c.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

