/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;
import org.wildfly.security.sasl.util.SaslFactories;

public final class MechanismProviderFilteringSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final BiPredicate<String, Provider> predicate;

    public MechanismProviderFilteringSaslServerFactory(SaslServerFactory delegate, BiPredicate<String, Provider> predicate) {
        super(delegate);
        this.predicate = predicate;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        BiPredicate<String, Provider> existing = SaslFactories.getProviderFilterPredicate(props);
        HashMap newProps = new HashMap(props);
        if (existing != null) {
            newProps.put("org.wildfly.internal.PFK", this.predicate.and(existing));
        } else {
            newProps.put("org.wildfly.internal.PFK", this.predicate);
        }
        return super.createSaslServer(mechanism, protocol, serverName, newProps, cbh);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        BiPredicate<String, Provider> existing = SaslFactories.getProviderFilterPredicate(props);
        HashMap newProps = new HashMap(props);
        if (existing != null) {
            newProps.put("org.wildfly.internal.PFK", this.predicate.and(existing));
        } else {
            newProps.put("org.wildfly.internal.PFK", this.predicate);
        }
        return super.getMechanismNames(newProps);
    }
}

