/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import io.airlift.airline.Option;
import java.nio.ByteBuffer;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionAbstract;
import org.apache.activemq.artemis.cli.factory.serialize.MessageSerializer;
import org.apache.activemq.artemis.cli.factory.serialize.XMLMessageSerializer;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;

public class DestAbstract
extends ConnectionAbstract {
    public static final String DEFAULT_MESSAGE_SERIALIZER = "org.apache.activemq.artemis.cli.factory.serialize.XMLMessageSerializer";
    private static final String FQQN_PREFIX = "fqqn://";
    private static final String FQQN_SEPERATOR = "::";
    @Option(name={"--destination"}, description="Destination to be used. It can be prefixed with queue:// or topic:// or fqqn:// (Default: queue://TEST)")
    String destination = "queue://TEST";
    @Option(name={"--message-count"}, description="Number of messages to act on (Default: 1000)")
    int messageCount = 1000;
    @Option(name={"--sleep"}, description="Time wait between each message")
    int sleep = 0;
    @Option(name={"--txt-size"}, description="TX Batch Size")
    int txBatchSize;
    @Option(name={"--threads"}, description="Number of Threads to be used (Default: 1)")
    int threads = 1;
    @Option(name={"--serializer"}, description="Override the default serializer with a custom implementation")
    String serializer;

    protected boolean isFQQN() throws ActiveMQException {
        boolean fqqn = this.destination.contains(FQQN_SEPERATOR);
        if (fqqn) {
            if (!this.destination.startsWith(FQQN_PREFIX)) {
                throw new ActiveMQException("FQQN destinations must start with the fqqn:// prefix");
            }
            if (this.protocol.equalsIgnoreCase("AMQP")) {
                throw new ActiveMQException("Sending to FQQN destinations is not support via AMQP protocol");
            }
            return true;
        }
        return false;
    }

    protected Destination lookupDestination(Session session) throws Exception {
        if (this.protocol.equals("AMQP")) {
            return session.createQueue(this.destination);
        }
        return ActiveMQDestination.createDestination((String)this.destination, (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
    }

    protected MessageSerializer getMessageSerializer() {
        if (this.serializer == null) {
            return new XMLMessageSerializer();
        }
        try {
            return (MessageSerializer)Class.forName(this.serializer).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Error: unable to instantiate serializer class: " + this.serializer);
            System.out.println("Defaulting to: org.apache.activemq.artemis.cli.factory.serialize.XMLMessageSerializer");
            return new XMLMessageSerializer();
        }
    }

    public byte[] getQueueIdFromName(String queueName) throws Exception {
        try {
            ClientMessage message = this.getQueueAttribute(queueName, "ID");
            Number idObject = (Number)ManagementHelper.getResult((ICoreMessage)message);
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.putLong(idObject.longValue());
            return byteBuffer.array();
        }
        catch (Exception e) {
            throw new ActiveMQException("Error occured when looking up FQQN.  Please ensure the FQQN exists.", (Throwable)e, ActiveMQExceptionType.ILLEGAL_STATE);
        }
    }

    /*
     * Exception decompiling
     */
    protected ClientMessage getQueueAttribute(String queueName, String attribute) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getQueueFromFQQN(String fqqn) {
        return fqqn.substring(fqqn.indexOf(FQQN_SEPERATOR) + FQQN_SEPERATOR.length());
    }

    protected String getAddressFromFQQN(String fqqn) {
        return fqqn.substring(fqqn.indexOf(FQQN_PREFIX) + FQQN_PREFIX.length(), fqqn.indexOf(FQQN_SEPERATOR));
    }

    protected String getFQQNFromDestination(String destination) {
        return destination.substring(destination.indexOf(FQQN_PREFIX) + FQQN_PREFIX.length());
    }
}

