/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.remote.AssociationImpl;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.ListenerHandle;
import org.jboss.ejb.server.ModuleAvailabilityListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.impl.MutableDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;

public final class AssociationService
implements Service<AssociationService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "association"});
    private final InjectedValue<DeploymentRepository> deploymentRepositoryInjector = new InjectedValue();
    private final InjectedValue<Registry> clientMappingsRegistryInjector = new InjectedValue();
    private final InjectedValue<SuspendController> suspendControllerInjector = new InjectedValue();
    private final InjectedValue<ServerEnvironment> serverEnvironmentServiceInjector = new InjectedValue();
    private final Object serviceLock = new Object();
    private final Set<EJBModuleIdentifier> ourModules = new HashSet<EJBModuleIdentifier>();
    private volatile ServiceURL cachedServiceURL;
    private final MutableDiscoveryProvider mutableDiscoveryProvider = new MutableDiscoveryProvider();
    private AssociationImpl value;
    private ListenerHandle moduleAvailabilityListener;

    public void start(StartContext context) throws StartException {
        Registry clientMappingsRegistry = (Registry)this.clientMappingsRegistryInjector.getOptionalValue();
        this.value = new AssociationImpl((DeploymentRepository)this.deploymentRepositoryInjector.getValue(), (Registry<String, List<ClientMapping>>)clientMappingsRegistry);
        String ourNodeName = ((ServerEnvironment)this.serverEnvironmentServiceInjector.getValue()).getNodeName();
        this.moduleAvailabilityListener = this.value.registerModuleAvailabilityListener(new ModuleAvailabilityListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void moduleAvailable(List<EJBModuleIdentifier> modules) {
                Object object = AssociationService.this.serviceLock;
                synchronized (object) {
                    AssociationService.this.ourModules.addAll(modules);
                    AssociationService.this.cachedServiceURL = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void moduleUnavailable(List<EJBModuleIdentifier> modules) {
                Object object = AssociationService.this.serviceLock;
                synchronized (object) {
                    AssociationService.this.ourModules.removeAll(modules);
                    AssociationService.this.cachedServiceURL = null;
                }
            }
        });
        this.mutableDiscoveryProvider.setDiscoveryProvider((serviceType, filterSpec, result) -> {
            ServiceURL serviceURL = this.cachedServiceURL;
            if (serviceURL == null) {
                Object object = this.serviceLock;
                synchronized (object) {
                    serviceURL = this.cachedServiceURL;
                    if (serviceURL == null) {
                        Group group;
                        ServiceURL.Builder b = new ServiceURL.Builder();
                        b.setUri(Affinity.LOCAL.getUri()).setAbstractType("ejb").setAbstractTypeAuthority("jboss");
                        b.addAttribute("node", AttributeValue.fromString((String)ourNodeName));
                        if (clientMappingsRegistry != null && !(group = clientMappingsRegistry.getGroup()).isSingleton()) {
                            b.addAttribute("cluster", AttributeValue.fromString((String)group.getName()));
                        }
                        for (EJBModuleIdentifier moduleIdentifier : this.ourModules) {
                            String appName = moduleIdentifier.getAppName();
                            String moduleName = moduleIdentifier.getModuleName();
                            String distinctName = moduleIdentifier.getDistinctName();
                            if (distinctName.isEmpty()) {
                                if (appName.isEmpty()) {
                                    b.addAttribute("ejb-module", AttributeValue.fromString((String)moduleName));
                                    continue;
                                }
                                b.addAttribute("ejb-module", AttributeValue.fromString((String)(appName + '/' + moduleName)));
                                continue;
                            }
                            if (appName.isEmpty()) {
                                b.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(moduleName + '/' + distinctName)));
                                continue;
                            }
                            b.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(appName + '/' + moduleName + '/' + distinctName)));
                        }
                        serviceURL = this.cachedServiceURL = b.create();
                    }
                }
            }
            if (serviceURL.satisfies(filterSpec)) {
                result.addMatch(serviceURL);
            }
            result.complete();
            return DiscoveryRequest.NULL;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        this.value.close();
        this.value = null;
        this.moduleAvailabilityListener.close();
        this.moduleAvailabilityListener = null;
        this.mutableDiscoveryProvider.setDiscoveryProvider(DiscoveryProvider.EMPTY);
        Object object = this.serviceLock;
        synchronized (object) {
            this.cachedServiceURL = null;
            this.ourModules.clear();
        }
    }

    public AssociationService getValue() {
        return this;
    }

    public InjectedValue<ServerEnvironment> getServerEnvironmentServiceInjector() {
        return this.serverEnvironmentServiceInjector;
    }

    public InjectedValue<DeploymentRepository> getDeploymentRepositoryInjector() {
        return this.deploymentRepositoryInjector;
    }

    public InjectedValue<Registry> getClientMappingsRegistryInjector() {
        return this.clientMappingsRegistryInjector;
    }

    public InjectedValue<SuspendController> getSuspendControllerInjector() {
        return this.suspendControllerInjector;
    }

    public DiscoveryProvider getLocalDiscoveryProvider() {
        return this.mutableDiscoveryProvider;
    }

    public Association getAssociation() {
        return this.value;
    }

    void setExecutor(Executor executor) {
        if (this.value != null) {
            this.value.setExecutor(executor);
        }
    }

    void sendTopologyUpdateIfLastNodeToLeave() {
        if (this.value != null) {
            this.value.sendTopologyUpdateIfLastNodeToLeave();
        }
    }
}

