/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.MetadataValueImpl;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.operations.IterationNextResponse;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;

public class IterationNextOperation<E>
extends HotRodOperation<IterationNextResponse<E>> {
    private final byte[] iterationId;
    private final Channel channel;
    private final KeyTracker segmentKeyTracker;
    private byte[] finishedSegments;
    private int entriesSize = -1;
    private List<Map.Entry<Object, E>> entries;
    private int projectionsSize;
    private int untrackedEntries;

    protected IterationNextOperation(Codec codec, int flags, Configuration cfg, byte[] cacheName, AtomicInteger topologyId, byte[] iterationId, Channel channel, ChannelFactory channelFactory, KeyTracker segmentKeyTracker, DataFormat dataFormat) {
        super((short)51, (short)52, codec, flags, cfg, cacheName, topologyId, channelFactory, dataFormat);
        this.iterationId = iterationId;
        this.channel = channel;
        this.segmentKeyTracker = segmentKeyTracker;
    }

    @Override
    public CompletableFuture<IterationNextResponse<E>> execute() {
        if (!this.channel.isActive()) {
            throw Log.HOTROD.channelInactive(this.channel.remoteAddress(), this.channel.remoteAddress());
        }
        this.scheduleRead(this.channel);
        this.sendArrayOperation(this.channel, this.iterationId);
        return this;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (this.entriesSize < 0) {
            this.finishedSegments = ByteBufUtil.readArray(buf);
            this.entriesSize = ByteBufUtil.readVInt(buf);
            if (this.entriesSize == 0) {
                this.segmentKeyTracker.segmentsFinished(this.finishedSegments);
                this.complete(new IterationNextResponse(status, Collections.emptyList(), false));
                return;
            }
            this.entries = new ArrayList<Map.Entry<Object, E>>(this.entriesSize);
            this.projectionsSize = this.codec.readProjectionSize(buf);
            decoder.checkpoint();
        }
        while (this.entries.size() + this.untrackedEntries < this.entriesSize) {
            Object value;
            short meta = this.codec.readMeta(buf);
            long creation = -1L;
            int lifespan = -1;
            long lastUsed = -1L;
            int maxIdle = -1;
            long version = 0L;
            if (meta == 1) {
                short flags = buf.readUnsignedByte();
                if ((flags & 1) != 1) {
                    creation = buf.readLong();
                    lifespan = ByteBufUtil.readVInt(buf);
                }
                if ((flags & 2) != 2) {
                    lastUsed = buf.readLong();
                    maxIdle = ByteBufUtil.readVInt(buf);
                }
                version = buf.readLong();
            }
            byte[] key = ByteBufUtil.readArray(buf);
            if (this.projectionsSize > 1) {
                Object[] projections = new Object[this.projectionsSize];
                for (int j = 0; j < this.projectionsSize; ++j) {
                    projections[j] = this.unmarshallValue(ByteBufUtil.readArray(buf), status);
                }
                value = projections;
            } else {
                value = this.unmarshallValue(ByteBufUtil.readArray(buf), status);
            }
            if (meta == 1) {
                value = new MetadataValueImpl<Object[]>(creation, lifespan, lastUsed, maxIdle, version, (Object[])value);
            }
            if (this.segmentKeyTracker.track(key, status, this.cfg.getClassWhiteList())) {
                Object unmarshallKey = this.dataFormat.keyToObj(key, this.cfg.getClassWhiteList());
                this.entries.add(new AbstractMap.SimpleEntry(unmarshallKey, (Object[])value));
            } else {
                ++this.untrackedEntries;
            }
            decoder.checkpoint();
        }
        this.segmentKeyTracker.segmentsFinished(this.finishedSegments);
        if (HotRodConstants.isInvalidIteration(status)) {
            throw Log.HOTROD.errorRetrievingNext(new String(this.iterationId, HOTROD_STRING_CHARSET));
        }
        this.complete(new IterationNextResponse<E>(status, this.entries, this.entriesSize > 0));
    }

    private Object unmarshallValue(byte[] bytes, short status) {
        return this.dataFormat.valueToObj(bytes, this.cfg.getClassWhiteList());
    }
}

