/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jaxrs.DeploymentRestResourcesDefintion;
import org.jboss.as.jaxrs.JaxrsAttribute;
import org.jboss.as.jaxrs.JaxrsDeploymentDefinition;
import org.jboss.as.jaxrs.JaxrsParamHandler;
import org.jboss.as.jaxrs.JaxrsSubsystemDefinition;
import org.jboss.as.jaxrs.JaxrsSubsystemParser_1_0;
import org.jboss.as.jaxrs.JaxrsSubsystemParser_2_0;
import org.jboss.as.jaxrs.logging.JaxrsLogger;

public class JaxrsExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jaxrs";
    public static final String NAMESPACE_1_0 = "urn:jboss:domain:jaxrs:1.0";
    public static final String NAMESPACE_2_0 = "urn:jboss:domain:jaxrs:2.0";
    public static final ModelVersion MODEL_VERSION_1_0_0 = ModelVersion.create((int)1, (int)0, (int)0);
    public static final ModelVersion MODEL_VERSION_2_0_0;
    private static final ModelVersion CURRENT_MODEL_VERSION;
    private static final String RESOURCE_NAME;
    static PathElement SUBSYSTEM_PATH;

    static ResourceDescriptionResolver getResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, JaxrsExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        JaxrsLogger.JAXRS_LOGGER.debug("Activating JAX-RS Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)JaxrsSubsystemDefinition.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        JaxrsExtension.registerAttributes(registration);
        ManagementResourceRegistration jaxrsResReg = subsystem.registerDeploymentModel((ResourceDefinition)JaxrsDeploymentDefinition.INSTANCE);
        jaxrsResReg.registerSubModel((ResourceDefinition)DeploymentRestResourcesDefintion.INSTANCE);
        subsystem.registerXMLElementWriter(JaxrsSubsystemParser_2_0::new);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_1_0, JaxrsSubsystemParser_1_0::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_2_0, JaxrsSubsystemParser_2_0::new);
    }

    private static void registerAttributes(ManagementResourceRegistration registration) {
        for (AttributeDefinition definition : JaxrsAttribute.ATTRIBUTES) {
            registration.registerReadWriteAttribute(definition, null, (OperationStepHandler)new JaxrsParamHandler(definition));
        }
    }

    static {
        CURRENT_MODEL_VERSION = MODEL_VERSION_2_0_0 = ModelVersion.create((int)2, (int)0, (int)0);
        RESOURCE_NAME = JaxrsExtension.class.getPackage().getName() + ".LocalDescriptions";
        SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME);
    }
}

