/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.Marshaller;

public class MarshalledValueMarshaller<V, C>
implements Marshaller<V, MarshalledValue<V, C>> {
    private final MarshalledValueFactory<C> factory;

    public MarshalledValueMarshaller(MarshalledValueFactory<C> factory) {
        this.factory = factory;
    }

    @Override
    public V read(MarshalledValue<V, C> value) throws InvalidSerializedFormException {
        if (value == null) {
            return null;
        }
        try {
            return value.get(this.factory.getMarshallingContext());
        }
        catch (InvalidClassException | InvalidObjectException | ClassNotFoundException e) {
            throw new InvalidSerializedFormException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public MarshalledValue<V, C> write(V object) {
        if (object == null) {
            return null;
        }
        return this.factory.createMarshalledValue(object);
    }

    @Override
    public boolean isMarshallable(Object object) {
        return this.factory.isMarshallable(object);
    }
}

