/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.function.Consumer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.service.PropertyService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

final class PropertyAdd
extends AbstractAddStepHandler {
    static final PropertyAdd INSTANCE = new PropertyAdd();

    private PropertyAdd() {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        super.rollbackRuntime(context, operation, resource);
        if (!context.isBooting()) {
            context.revertReloadRequired();
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String propertyName = address.getElement(address.size() - 1).getValue();
            PathElement confElem = address.getElement(address.size() - 2);
            String configType = confElem.getKey();
            String configName = confElem.getValue();
            String propertyValue = operation.has("value") ? Attributes.VALUE.resolveModelAttribute(context, operation).asString() : null;
            ServiceTarget target = context.getServiceTarget();
            ServiceName configServiceName = PackageUtils.getConfigServiceName(configType, configName);
            if (context.getServiceRegistry(false).getService(configServiceName) == null) {
                throw WSLogger.ROOT_LOGGER.missingConfig(configName);
            }
            ServiceName propertyServiceName = PackageUtils.getPropertyServiceName(configServiceName, propertyName);
            ServiceBuilder propertyServiceBuilder = target.addService(propertyServiceName);
            Consumer propertyServiceConsumer = propertyServiceBuilder.provides(new ServiceName[]{propertyServiceName});
            propertyServiceBuilder.setInstance((Service)new PropertyService(propertyName, propertyValue, propertyServiceConsumer));
            propertyServiceBuilder.install();
        } else {
            context.reloadRequired();
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        Attributes.VALUE.validateAndSet(operation, model);
    }
}

