/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collections;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.parsing.Element;

public class ContentTypeConfiguration
implements ConfigurationInfo {
    public static final String DEFAULT_MEDIA_TYPE = "application/x-java-object";
    public static final ElementDefinition KEY_ELEMENT_DEFINITION = new DefaultElementDefinition(Element.KEY_DATA_TYPE.getLocalName());
    public static final ElementDefinition VALUE_ELEMENT_DEFINITION = new DefaultElementDefinition(Element.VALUE_DATA_TYPE.getLocalName());
    public static final AttributeDefinition<String> MEDIA_TYPE = AttributeDefinition.builder((String)"media-type", null, String.class).build();
    private final Attribute<String> mediaType;
    private final boolean key;
    private final AttributeSet attributes;

    ContentTypeConfiguration(boolean key, AttributeSet attributes) {
        this.key = key;
        this.attributes = attributes.checkProtection();
        this.mediaType = attributes.attribute(MEDIA_TYPE);
    }

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ContentTypeConfiguration.class, new AttributeDefinition[]{MEDIA_TYPE});
    }

    public MediaType mediaType() {
        if (this.mediaType.isNull()) {
            return null;
        }
        return MediaType.fromString((String)((String)this.mediaType.get()));
    }

    public void mediaType(MediaType mediaType) {
        this.attributes.attribute(MEDIA_TYPE).set((Object)mediaType.toString());
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return this.key ? KEY_ELEMENT_DEFINITION : VALUE_ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return Collections.emptyList();
    }

    public boolean isMediaTypeChanged() {
        return this.attributes.attribute(MEDIA_TYPE).isModified();
    }

    public boolean isEncodingChanged() {
        return this.attributes.attribute(MEDIA_TYPE).isModified();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentTypeConfiguration that = (ContentTypeConfiguration)o;
        if (this.key != that.key) {
            return false;
        }
        return this.attributes != null ? this.attributes.equals((Object)that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        int result = this.key ? 1 : 0;
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ContentTypeConfiguration [attributes=" + this.attributes + "]";
    }
}

