/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfiguration;

public class ManagedConnectionFactoryConfigurationBuilder<S extends AbstractJdbcStoreConfigurationBuilder<?, S>>
extends AbstractJdbcStoreConfigurationChildBuilder<S>
implements ConnectionFactoryConfigurationBuilder<ManagedConnectionFactoryConfiguration>,
ConfigurationBuilderInfo {
    private final AttributeSet attributes = ManagedConnectionFactoryConfiguration.attributeSet();

    public ManagedConnectionFactoryConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, S> builder) {
        super(builder);
    }

    public void jndiUrl(String jndiUrl) {
        this.attributes.attribute(ManagedConnectionFactoryConfiguration.JNDI_URL).set((Object)jndiUrl);
    }

    public void validate() {
        String jndiUrl = (String)this.attributes.attribute(ManagedConnectionFactoryConfiguration.JNDI_URL).get();
        if (jndiUrl == null) {
            throw new CacheConfigurationException("The jndiUrl has not been specified");
        }
    }

    public ElementDefinition getElementDefinition() {
        return ManagedConnectionFactoryConfiguration.ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public void validate(GlobalConfiguration globalConfig) {
    }

    public ManagedConnectionFactoryConfiguration create() {
        return new ManagedConnectionFactoryConfiguration(this.attributes.protect());
    }

    public ManagedConnectionFactoryConfigurationBuilder<S> read(ManagedConnectionFactoryConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

