/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.transaction.operations.PrepareTransactionOperation;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.CacheException;

public class Util {
    private static final long BIG_DELAY_NANOS = TimeUnit.DAYS.toNanos(1L);
    private static final Xid DUMMY_XID = new Xid(){

        @Override
        public int getFormatId() {
            return 0;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            return new byte[]{1};
        }

        @Override
        public byte[] getBranchQualifier() {
            return new byte[]{1};
        }
    };

    private Util() {
    }

    public static <T> T await(CompletableFuture<T> cf) {
        try {
            return cf.get(BIG_DELAY_NANOS, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRodClientException(e);
        }
        catch (ExecutionException e) {
            throw Util.rewrap(e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T await(CompletableFuture<T> cf, long timeoutMillis) {
        try {
            return cf.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRodClientException(e);
        }
        catch (ExecutionException e) {
            throw Util.rewrap(e);
        }
        catch (TimeoutException e) {
            cf.cancel(false);
            throw new TransportException(new SocketTimeoutException(), null);
        }
    }

    protected static RuntimeException rewrap(ExecutionException e) {
        if (e.getCause() instanceof HotRodClientException) {
            return (HotRodClientException)e.getCause();
        }
        if (e.getCause() instanceof CacheException) {
            return (CacheException)e.getCause();
        }
        return new TransportException(e.getCause(), null);
    }

    public static CompletionStage<Boolean> checkTransactionSupport(String cacheName, OperationsFactory factory) {
        PrepareTransactionOperation op = factory.newPrepareTransactionOperation(DUMMY_XID, true, Collections.emptyList(), false, 60000L);
        return op.execute().handle((integer, throwable) -> {
            if (throwable != null) {
                Log.HOTROD.invalidTxServerConfig(cacheName, (Throwable)throwable);
            }
            return throwable == null;
        });
    }

    public static boolean checkTransactionSupport(String cacheName, OperationsFactory factory, Log log) {
        PrepareTransactionOperation op = factory.newPrepareTransactionOperation(DUMMY_XID, true, Collections.emptyList(), false, 60000L);
        try {
            return (Boolean)((CompletableFuture)op.execute().handle((integer, throwable) -> {
                if (throwable != null) {
                    Log.HOTROD.invalidTxServerConfig(cacheName, (Throwable)throwable);
                }
                return throwable == null;
            })).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            log.debugf("Exception while checking transaction support in server", e);
        }
        return false;
    }
}

