/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.util.Arrays;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Marshaller;

public class BytesOnlyMarshaller
implements Marshaller {
    public static final BytesOnlyMarshaller INSTANCE = new BytesOnlyMarshaller();
    private static final BufferSizePredictor predictor = new IdentityBufferSizePredictor();

    private BytesOnlyMarshaller() {
    }

    private void checkByteArray(Object o) {
        if (!(o instanceof byte[])) {
            throw new IllegalArgumentException("Only byte[] instances are supported currently!");
        }
    }

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) {
        this.checkByteArray(obj);
        return (byte[])obj;
    }

    public byte[] objectToByteBuffer(Object obj) {
        this.checkByteArray(obj);
        return (byte[])obj;
    }

    public Object objectFromByteBuffer(byte[] buf) {
        return buf;
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) {
        if (offset == 0 && length == buf.length) {
            return buf;
        }
        return Arrays.copyOfRange(buf, offset, offset + length);
    }

    public ByteBuffer objectToBuffer(Object o) {
        this.checkByteArray(o);
        byte[] b = (byte[])o;
        return new ByteBufferImpl(b, 0, b.length);
    }

    public boolean isMarshallable(Object o) {
        return o instanceof byte[];
    }

    public BufferSizePredictor getBufferSizePredictor(Object o) {
        return predictor;
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_OCTET_STREAM;
    }

    private static final class IdentityBufferSizePredictor
    implements BufferSizePredictor {
        private IdentityBufferSizePredictor() {
        }

        public int nextSize(Object obj) {
            return ((byte[])obj).length;
        }

        public void recordSize(int previousSize) {
        }
    }
}

