/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueMarshaller;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.session.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;

public abstract class MarshalledValueSessionAttributesFactoryConfiguration<S, SC, AL, V, MC, LC>
implements SessionAttributesFactoryConfiguration<S, SC, AL, V, MarshalledValue<V, MC>> {
    private final Immutability immutability;
    private final Marshaller<V, MarshalledValue<V, MC>> marshaller;
    private final HttpSessionActivationListenerProvider<S, SC, AL> provider;

    protected MarshalledValueSessionAttributesFactoryConfiguration(SessionManagerFactoryConfiguration<S, SC, AL, ?, MC, LC> configuration) {
        MarshalledValueFactory factory = configuration.getMarshalledValueFactory();
        this.immutability = configuration.getImmutability();
        this.marshaller = new MarshalledValueMarshaller(factory);
        this.provider = configuration.getSpecificationProvider();
    }

    @Override
    public Marshaller<V, MarshalledValue<V, MC>> getMarshaller() {
        return this.marshaller;
    }

    @Override
    public Immutability getImmutability() {
        return this.immutability;
    }

    @Override
    public HttpSessionActivationListenerProvider<S, SC, AL> getHttpSessionActivationListenerProvider() {
        return this.provider;
    }
}

