/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.CollectionAttributeCopier;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.global.WhiteListConfiguration;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.protostream.SerializationContextInitializer;

public class SerializationConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<Marshaller> MARSHALLER = AttributeDefinition.builder((String)"marshaller", null, Marshaller.class).immutable().build();
    public static final AttributeDefinition<Short> VERSION = AttributeDefinition.builder((String)"version", (Object)Version.getMarshallVersion()).serializer((AttributeSerializer)new AttributeSerializer<Short, ConfigurationInfo, ConfigurationBuilderInfo>(){

        public Object getSerializationValue(Attribute<Short> attribute, ConfigurationInfo configurationElement) {
            return Version.decodeVersion((short)((Short)attribute.get()));
        }
    }).immutable().build();
    public static final AttributeDefinition<Object> CLASS_RESOLVER = AttributeDefinition.builder((String)"classResolver", null, Object.class).immutable().build();
    public static final AttributeDefinition<Map<Integer, AdvancedExternalizer<?>>> ADVANCED_EXTERNALIZERS = AttributeDefinition.builder((String)"advancedExternalizer", null, Map.class).copier(CollectionAttributeCopier.INSTANCE).initializer(HashMap::new).immutable().build();
    public static final AttributeDefinition<List<SerializationContextInitializer>> SERIALIZATION_CONTEXT_INITIALIZERS = AttributeDefinition.builder((String)"contextInitializers", null, List.class).immutable().build();
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.SERIALIZATION.getLocalName());
    private final Attribute<Map<Integer, AdvancedExternalizer<?>>> advancedExternalizers;
    private final Attribute<Object> classResolver;
    private final Attribute<Marshaller> marshaller;
    private final Attribute<Short> version;
    private final Attribute<List<SerializationContextInitializer>> contextInitializers;
    private final AttributeSet attributes;
    private final WhiteListConfiguration whiteListConfig;
    private final List<ConfigurationInfo> subElements;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SerializationConfiguration.class, new AttributeDefinition[]{MARSHALLER, VERSION, CLASS_RESOLVER, ADVANCED_EXTERNALIZERS, SERIALIZATION_CONTEXT_INITIALIZERS});
    }

    SerializationConfiguration(AttributeSet attributes, WhiteListConfiguration whiteListConfig) {
        this.attributes = attributes.checkProtection();
        this.marshaller = attributes.attribute(MARSHALLER);
        this.version = attributes.attribute(VERSION);
        this.classResolver = attributes.attribute(CLASS_RESOLVER);
        this.advancedExternalizers = attributes.attribute(ADVANCED_EXTERNALIZERS);
        this.contextInitializers = attributes.attribute(SERIALIZATION_CONTEXT_INITIALIZERS);
        this.whiteListConfig = whiteListConfig;
        this.subElements = Collections.singletonList(whiteListConfig);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public Marshaller marshaller() {
        return (Marshaller)this.marshaller.get();
    }

    @Deprecated
    public short version() {
        return (Short)this.version.get();
    }

    public Map<Integer, AdvancedExternalizer<?>> advancedExternalizers() {
        return (Map)this.advancedExternalizers.get();
    }

    @Deprecated
    public Object classResolver() {
        return this.classResolver.get();
    }

    public List<SerializationContextInitializer> contextInitializers() {
        return (List)this.contextInitializers.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public WhiteListConfiguration whiteList() {
        return this.whiteListConfig;
    }

    public String toString() {
        return "SerializationConfiguration{attributes=" + this.attributes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializationConfiguration that = (SerializationConfiguration)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }
}

