/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.spi.MarshallableEntry;

public class BatchModification {
    private final Map<Object, MarshallableEntry> marshalledEntries = new HashMap<Object, MarshallableEntry>();
    private final Set<Object> keysToRemove = new HashSet<Object>();
    private final Set<Object> affectedKeys;

    public BatchModification(Set<Object> affectedKeys) {
        this.affectedKeys = affectedKeys;
    }

    public void addMarshalledEntry(Object key, MarshallableEntry marshalledEntry) {
        this.keysToRemove.remove(key);
        this.marshalledEntries.put(key, marshalledEntry);
    }

    public void removeEntry(Object key) {
        this.marshalledEntries.remove(key);
        this.keysToRemove.add(key);
    }

    public Set<Object> getAffectedKeys() {
        return this.affectedKeys;
    }

    public Set<Object> getKeysToRemove() {
        return this.keysToRemove;
    }

    @Deprecated
    public Collection<MarshalledEntry> getMarshalledEntries() {
        return this.marshalledEntries.values().stream().map(MarshallableEntry::asMarshalledEntry).collect(Collectors.toList());
    }

    public Collection<MarshallableEntry> getMarshallableEntries() {
        return this.marshalledEntries.values();
    }
}

