/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.logging;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import javax.naming.InvalidNameException;
import javax.naming.OperationNotSupportedException;
import javax.security.auth.login.LoginException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;
import org.jboss.security.vault.SecurityVaultException;

public class SecurityLogger_$logger
extends DelegatingBasicLogger
implements SecurityLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SecurityLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public SecurityLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void currentVersion(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.currentVersion$str(), (Object)version);
    }

    protected String currentVersion$str() {
        return "WFLYSEC0001: Current PicketBox version=%s";
    }

    @Override
    public final void activatingSecuritySubsystem() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.activatingSecuritySubsystem$str(), new Object[0]);
    }

    protected String activatingSecuritySubsystem$str() {
        return "WFLYSEC0002: Activating Security Subsystem";
    }

    @Override
    public final void errorDeletingJACCPolicy(Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.errorDeletingJACCPolicy$str(), new Object[0]);
    }

    protected String errorDeletingJACCPolicy$str() {
        return "WFLYSEC0003: Error deleting JACC Policy";
    }

    protected String unableToGetModuleClassLoader$str() {
        return "WFLYSEC0004: Unable to get the Module Class Loader";
    }

    @Override
    public final IllegalStateException unableToGetModuleClassLoader(Throwable e) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToGetModuleClassLoader$str(), new Object[0]), e);
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String operationNotSupported$str() {
        return "WFLYSEC0005: Operation not supported : %s";
    }

    @Override
    public final OperationNotSupportedException operationNotSupported(Method method) {
        OperationNotSupportedException result = new OperationNotSupportedException(String.format(this.getLoggingLocale(), this.operationNotSupported$str(), method));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingModuleName$str() {
        return "WFLYSEC0006: Missing module name for the %s";
    }

    @Override
    public final IllegalArgumentException missingModuleName(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingModuleName$str(), name));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String runtimeException$str() {
        return "WFLYSEC0007: Runtime Exception:";
    }

    @Override
    public final RuntimeException runtimeException(Throwable e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.runtimeException$str(), new Object[0]), e);
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullName$str() {
        return "WFLYSEC0009: Name cannot be null or empty";
    }

    @Override
    public final InvalidNameException nullName() {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.nullName$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullArgument$str() {
        return "WFLYSEC0011: Argument %s is null";
    }

    @Override
    public final IllegalArgumentException nullArgument(String arg) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullArgument$str(), arg));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToStartException$str() {
        return "WFLYSEC0012: Unable to start the %s service";
    }

    @Override
    public final StartException unableToStartException(String service, Throwable t) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToStartException$str(), service), t);
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cnfe$str() {
        return "WFLYSEC0013: Class not found : %s";
    }

    @Override
    public final ClassNotFoundException cnfe(String name) {
        ClassNotFoundException result = new ClassNotFoundException(String.format(this.getLoggingLocale(), this.cnfe$str(), name));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String securityException$str() {
        return "WFLYSEC0015: Security Exception";
    }

    @Override
    public final SecurityException securityException(Throwable t) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.securityException$str(), new Object[0]), t);
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String vaultReaderException$str() {
        return "WFLYSEC0017: Vault Reader Exception:";
    }

    @Override
    public final VaultReaderException vaultReaderException(Throwable t) {
        VaultReaderException result = new VaultReaderException(String.format(this.getLoggingLocale(), this.vaultReaderException$str(), new Object[0]), t);
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedOperationExceptionUseResourceDesc$str() {
        return "WFLYSEC0018: Use the ResourceDescriptionResolver variant";
    }

    @Override
    public final UnsupportedOperationException unsupportedOperationExceptionUseResourceDesc() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedOperationExceptionUseResourceDesc$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedOperation$str() {
        return "WFLYSEC0019: Unsupported Operation";
    }

    @Override
    public final UnsupportedOperationException unsupportedOperation() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedOperation$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlStreamExceptionAuth$str() {
        return "WFLYSEC0022: A security domain can have either an <authentication> or <authentication-jaspi> element, not both";
    }

    @Override
    public final XMLStreamException xmlStreamExceptionAuth(Location loc) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.xmlStreamExceptionAuth$str(), new Object[0]), loc);
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlStreamExceptionMissingAttribute$str() {
        return "WFLYSEC0023: Missing required attribute: either %s or %s must be present";
    }

    @Override
    public final XMLStreamException xmlStreamExceptionMissingAttribute(String a, String b, Location loc) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.xmlStreamExceptionMissingAttribute$str(), a, b), loc);
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String loginModuleStackIllegalArgument$str() {
        return "WFLYSEC0024: auth-module references a login module stack that doesn't exist::%s";
    }

    @Override
    public final IllegalArgumentException loginModuleStackIllegalArgument(String str) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.loginModuleStackIllegalArgument$str(), str));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String addressDidNotContainSecurityDomain$str() {
        return "WFLYSEC0025: Address did not contain a security domain name";
    }

    @Override
    public final IllegalArgumentException addressDidNotContainSecurityDomain() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.addressDidNotContainSecurityDomain$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String vaultNotInitializedException$str() {
        return "WFLYSEC0026: Vault is not initialized";
    }

    @Override
    public final SecurityException vaultNotInitializedException() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.vaultNotInitializedException$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidUserException$str() {
        return "WFLYSEC0027: Invalid User";
    }

    @Override
    public final SecurityException invalidUserException() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.invalidUserException$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String securityManagementNotInjected$str() {
        return "WFLYSEC0028: Security Management not injected";
    }

    @Override
    public final SecurityException securityManagementNotInjected() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.securityManagementNotInjected$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String realmNotFound$str() {
        return "WFLYSEC0029: Security realm '%s' not found.";
    }

    @Override
    public final SecurityException realmNotFound(String name) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.realmNotFound$str(), name));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failureCallingSecurityRealm$str() {
        return "WFLYSEC0031: Failure calling CallbackHandler '%s'";
    }

    @Override
    public final LoginException failureCallingSecurityRealm(String cause) {
        LoginException result = new LoginException(String.format(this.getLoggingLocale(), this.failureCallingSecurityRealm$str(), cause));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noAuthenticationCacheAvailable$str() {
        return "WFLYSEC0032: No authentication cache for security domain '%s' available";
    }

    @Override
    public final OperationFailedException noAuthenticationCacheAvailable(String securityDomain) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noAuthenticationCacheAvailable$str(), securityDomain));
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noUserPrincipalFound$str() {
        return "WFLYSEC0033: No UserPrincipalFound constructing RemotingConnectionPrincipal.";
    }

    @Override
    public final IllegalStateException noUserPrincipalFound() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noUserPrincipalFound$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String interruptedWaitingForSecurityDomain$str() {
        return "WFLYSEC0034: Interrupted waiting for security domain '%s'";
    }

    @Override
    public final OperationFailedException interruptedWaitingForSecurityDomain(String securityDomainName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.interruptedWaitingForSecurityDomain$str(), securityDomainName));
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String requiredSecurityDomainServiceNotAvailable$str() {
        return "WFLYSEC0035: Required security domain is not available '%s'";
    }

    @Override
    public final OperationFailedException requiredSecurityDomainServiceNotAvailable(String securityDomainName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.requiredSecurityDomainServiceNotAvailable$str(), securityDomainName));
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String keyStoreDoesnotExistWithExample$str() {
        return "WFLYSEC0037: Keystore '%s' doesn't exist.\nkeystore could be created: keytool -genseckey -alias Vault -storetype jceks -keyalg AES -keysize 128 -storepass secretsecret -keypass secretsecret -keystore %s";
    }

    @Override
    public final Exception keyStoreDoesnotExistWithExample(String keystoreURL, String keystoreURLExample) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.keyStoreDoesnotExistWithExample$str(), keystoreURL, keystoreURLExample));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStoreNotWritable$str() {
        return "WFLYSEC0038: Keystore [%s] is not writable or not a file.";
    }

    @Override
    public final Exception keyStoreNotWritable(String keystoreURL) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.keyStoreNotWritable$str(), keystoreURL));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStorePasswordNotSpecified$str() {
        return "WFLYSEC0039: Keystore password has to be specified.";
    }

    @Override
    public final Exception keyStorePasswordNotSpecified() {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.keyStorePasswordNotSpecified$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String encryptionDirectoryDoesNotExist$str() {
        return "WFLYSEC0041: Encryption directory is not a directory or doesn't exist. (%s)";
    }

    @Override
    public final Exception encryptionDirectoryDoesNotExist(String directory) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.encryptionDirectoryDoesNotExist$str(), directory));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateEncryptionDirectory$str() {
        return "WFLYSEC0042: Cannot create encryption directory %s";
    }

    @Override
    public final Exception cannotCreateEncryptionDirectory(String directory) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.cannotCreateEncryptionDirectory$str(), directory));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String iterationCountOutOfRange$str() {
        return "WFLYSEC0043: Iteration count has to be within 1 - 2147483647, but it is %s.";
    }

    @Override
    public final Exception iterationCountOutOfRange(String iteration) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.iterationCountOutOfRange$str(), iteration));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String saltWrongLength$str() {
        return "WFLYSEC0044: Salt has to be exactly 8 characters long.";
    }

    @Override
    public final Exception saltWrongLength() {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.saltWrongLength$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String securityVaultException$str() {
        return "WFLYSEC0045: Exception encountered:";
    }

    @Override
    public final Exception securityVaultException(SecurityVaultException cause) {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.securityVaultException$str(), new Object[0]), (Throwable)cause);
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String vaultAliasNotSpecified$str() {
        return "WFLYSEC0046: Vault alias has to be specified.";
    }

    @Override
    public final Exception vaultAliasNotSpecified() {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.vaultAliasNotSpecified$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String vaultAttributeCreateDisplay$str() {
        return "WFLYSEC0047: Secured attribute value has been stored in Vault.\nPlease make note of the following:\n********************************************\nVault Block:%s\nAttribute Name:%s\nConfiguration should be done as follows:\n%s\n********************************************";
    }

    @Override
    public final String vaultAttributeCreateDisplay(String VaultBlock, String attributeName, String configurationString) {
        return String.format(this.getLoggingLocale(), this.vaultAttributeCreateDisplay$str(), VaultBlock, attributeName, configurationString);
    }

    protected String vaultConfigurationTitle$str() {
        return "WFLYSEC0048: Vault Configuration commands in WildFly for CLI:";
    }

    @Override
    public final String vaultConfigurationTitle() {
        return String.format(this.getLoggingLocale(), this.vaultConfigurationTitle$str(), new Object[0]);
    }

    protected String noConsole$str() {
        return "WFLYSEC0049: No console.";
    }

    @Override
    public final String noConsole() {
        return String.format(this.getLoggingLocale(), this.noConsole$str(), new Object[0]);
    }

    protected String enterEncryptionDirectory$str() {
        return "Enter directory to store encrypted files:";
    }

    @Override
    public final String enterEncryptionDirectory() {
        return String.format(this.getLoggingLocale(), this.enterEncryptionDirectory$str(), new Object[0]);
    }

    protected String enterKeyStoreURL$str() {
        return "Enter Keystore URL:";
    }

    @Override
    public final String enterKeyStoreURL() {
        return String.format(this.getLoggingLocale(), this.enterKeyStoreURL$str(), new Object[0]);
    }

    protected String enterKeyStorePassword$str() {
        return "Enter Keystore password:";
    }

    @Override
    public final String enterKeyStorePassword() {
        return String.format(this.getLoggingLocale(), this.enterKeyStorePassword$str(), new Object[0]);
    }

    protected String enterSalt$str() {
        return "Enter 8 character salt:";
    }

    @Override
    public final String enterSalt() {
        return String.format(this.getLoggingLocale(), this.enterSalt$str(), new Object[0]);
    }

    protected String enterIterationCount$str() {
        return "Enter iteration count as a number (e.g.: 44):";
    }

    @Override
    public final String enterIterationCount() {
        return String.format(this.getLoggingLocale(), this.enterIterationCount$str(), new Object[0]);
    }

    protected String enterKeyStoreAlias$str() {
        return "Enter Keystore Alias:";
    }

    @Override
    public final String enterKeyStoreAlias() {
        return String.format(this.getLoggingLocale(), this.enterKeyStoreAlias$str(), new Object[0]);
    }

    protected String initializingVault$str() {
        return "WFLYSEC0056: Initializing Vault";
    }

    @Override
    public final String initializingVault() {
        return String.format(this.getLoggingLocale(), this.initializingVault$str(), new Object[0]);
    }

    protected String vaultInitialized$str() {
        return "WFLYSEC0057: Vault is initialized and ready for use";
    }

    @Override
    public final String vaultInitialized() {
        return String.format(this.getLoggingLocale(), this.vaultInitialized$str(), new Object[0]);
    }

    protected String handshakeComplete$str() {
        return "WFLYSEC0058: Handshake with Vault complete";
    }

    @Override
    public final String handshakeComplete() {
        return String.format(this.getLoggingLocale(), this.handshakeComplete$str(), new Object[0]);
    }

    protected String exceptionEncountered$str() {
        return "WFLYSEC0059: Exception encountered:";
    }

    @Override
    public final String exceptionEncountered() {
        return String.format(this.getLoggingLocale(), this.exceptionEncountered$str(), new Object[0]);
    }

    protected String enterYourPassword$str() {
        return "Enter your password:";
    }

    @Override
    public final String enterYourPassword() {
        return String.format(this.getLoggingLocale(), this.enterYourPassword$str(), new Object[0]);
    }

    protected String passwordAgain$str() {
        return "WFLYSEC0061:  again: ";
    }

    @Override
    public final String passwordAgain() {
        return String.format(this.getLoggingLocale(), this.passwordAgain$str(), new Object[0]);
    }

    protected String passwordsDoNotMatch$str() {
        return "Values entered don't match";
    }

    @Override
    public final String passwordsDoNotMatch() {
        return String.format(this.getLoggingLocale(), this.passwordsDoNotMatch$str(), new Object[0]);
    }

    protected String passwordsMatch$str() {
        return "Values match";
    }

    @Override
    public final String passwordsMatch() {
        return String.format(this.getLoggingLocale(), this.passwordsMatch$str(), new Object[0]);
    }

    protected String problemOcurred$str() {
        return "Problem occurred:";
    }

    @Override
    public final String problemOcurred() {
        return String.format(this.getLoggingLocale(), this.problemOcurred$str(), new Object[0]);
    }

    protected String interactiveCommandString$str() {
        return "Please enter a Digit::   0: Start Interactive Session   1: Remove Interactive Session  2: Exit";
    }

    @Override
    public final String interactiveCommandString() {
        return String.format(this.getLoggingLocale(), this.interactiveCommandString$str(), new Object[0]);
    }

    protected String startingInteractiveSession$str() {
        return "Starting an interactive session";
    }

    @Override
    public final String startingInteractiveSession() {
        return String.format(this.getLoggingLocale(), this.startingInteractiveSession$str(), new Object[0]);
    }

    protected String removingInteractiveSession$str() {
        return "Removing the current interactive session";
    }

    @Override
    public final String removingInteractiveSession() {
        return String.format(this.getLoggingLocale(), this.removingInteractiveSession$str(), new Object[0]);
    }

    protected String problemParsingCommandLineParameters$str() {
        return "WFLYSEC0068: Problem while parsing command line parameters:";
    }

    @Override
    public final String problemParsingCommandLineParameters() {
        return String.format(this.getLoggingLocale(), this.problemParsingCommandLineParameters$str(), new Object[0]);
    }

    protected String cmdLineKeyStoreURL$str() {
        return "Keystore URL";
    }

    @Override
    public final String cmdLineKeyStoreURL() {
        return String.format(this.getLoggingLocale(), this.cmdLineKeyStoreURL$str(), new Object[0]);
    }

    protected String cmdLineKeyStorePassword$str() {
        return "Keystore password";
    }

    @Override
    public final String cmdLineKeyStorePassword() {
        return String.format(this.getLoggingLocale(), this.cmdLineKeyStorePassword$str(), new Object[0]);
    }

    protected String cmdLineEncryptionDirectory$str() {
        return "Directory containing encrypted files";
    }

    @Override
    public final String cmdLineEncryptionDirectory() {
        return String.format(this.getLoggingLocale(), this.cmdLineEncryptionDirectory$str(), new Object[0]);
    }

    protected String cmdLineSalt$str() {
        return "8 character salt";
    }

    @Override
    public final String cmdLineSalt() {
        return String.format(this.getLoggingLocale(), this.cmdLineSalt$str(), new Object[0]);
    }

    protected String cmdLineIterationCount$str() {
        return "Iteration count";
    }

    @Override
    public final String cmdLineIterationCount() {
        return String.format(this.getLoggingLocale(), this.cmdLineIterationCount$str(), new Object[0]);
    }

    protected String cmdLineVaultKeyStoreAlias$str() {
        return "Vault keystore alias";
    }

    @Override
    public final String cmdLineVaultKeyStoreAlias() {
        return String.format(this.getLoggingLocale(), this.cmdLineVaultKeyStoreAlias$str(), new Object[0]);
    }

    protected String cmdLineVaultBlock$str() {
        return "Vault block";
    }

    @Override
    public final String cmdLineVaultBlock() {
        return String.format(this.getLoggingLocale(), this.cmdLineVaultBlock$str(), new Object[0]);
    }

    protected String cmdLineAttributeName$str() {
        return "Attribute name";
    }

    @Override
    public final String cmdLineAttributeName() {
        return String.format(this.getLoggingLocale(), this.cmdLineAttributeName$str(), new Object[0]);
    }

    protected String cmdLineSecuredAttribute$str() {
        return "Secured attribute value (such as password) to store";
    }

    @Override
    public final String cmdLineSecuredAttribute() {
        return String.format(this.getLoggingLocale(), this.cmdLineSecuredAttribute$str(), new Object[0]);
    }

    protected String cmdLineCheckAttribute$str() {
        return "Check whether the secured attribute already exists in the Vault";
    }

    @Override
    public final String cmdLineCheckAttribute() {
        return String.format(this.getLoggingLocale(), this.cmdLineCheckAttribute$str(), new Object[0]);
    }

    protected String cmdLineHelp$str() {
        return "Help";
    }

    @Override
    public final String cmdLineHelp() {
        return String.format(this.getLoggingLocale(), this.cmdLineHelp$str(), new Object[0]);
    }

    protected String cmdLineSecuredAttributeAlreadyExists$str() {
        return "WFLYSEC0080: Secured attribute (password) already exists.";
    }

    @Override
    public final String cmdLineSecuredAttributeAlreadyExists() {
        return String.format(this.getLoggingLocale(), this.cmdLineSecuredAttributeAlreadyExists$str(), new Object[0]);
    }

    protected String cmdLineSecuredAttributeDoesNotExist$str() {
        return "WFLYSEC0081: Secured attribute (password) doesn't exist.";
    }

    @Override
    public final String cmdLineSecuredAttributeDoesNotExist() {
        return String.format(this.getLoggingLocale(), this.cmdLineSecuredAttributeDoesNotExist$str(), new Object[0]);
    }

    protected String enterYourPasswordAgain$str() {
        return "Enter your password again:";
    }

    @Override
    public final String enterYourPasswordAgain() {
        return String.format(this.getLoggingLocale(), this.enterYourPasswordAgain$str(), new Object[0]);
    }

    protected String enterKeyStorePasswordAgain$str() {
        return "Enter Keystore password again:";
    }

    @Override
    public final String enterKeyStorePasswordAgain() {
        return String.format(this.getLoggingLocale(), this.enterKeyStorePasswordAgain$str(), new Object[0]);
    }

    protected String cmdLineRemoveSecuredAttribute$str() {
        return "Remove secured attribute from the Vault";
    }

    @Override
    public final String cmdLineRemoveSecuredAttribute() {
        return String.format(this.getLoggingLocale(), this.cmdLineRemoveSecuredAttribute$str(), new Object[0]);
    }

    protected String cmdLineAutomaticallyCreateKeystore$str() {
        return "Automatically create keystore when it doesn't exist";
    }

    @Override
    public final String cmdLineAutomaticallyCreateKeystore() {
        return String.format(this.getLoggingLocale(), this.cmdLineAutomaticallyCreateKeystore$str(), new Object[0]);
    }

    protected String messageAttributeRemovedSuccessfuly$str() {
        return "Secured attribute %s has been successfuly removed from vault";
    }

    @Override
    public final String messageAttributeRemovedSuccessfuly(String displayFormattedAttribute) {
        return String.format(this.getLoggingLocale(), this.messageAttributeRemovedSuccessfuly$str(), displayFormattedAttribute);
    }

    protected String messageAttributeNotRemoved$str() {
        return "Secured attribute %s was not removed from vault, check whether it exist";
    }

    @Override
    public final String messageAttributeNotRemoved(String displayFormattedAttribute) {
        return String.format(this.getLoggingLocale(), this.messageAttributeNotRemoved$str(), displayFormattedAttribute);
    }

    protected String interactionCommandOptions$str() {
        return "Please enter a Digit::  0: Store a secured attribute  1: Check whether a secured attribute exists  2: Remove secured attribute  3: Exit";
    }

    @Override
    public final String interactionCommandOptions() {
        return String.format(this.getLoggingLocale(), this.interactionCommandOptions$str(), new Object[0]);
    }

    protected String taskStoreSecuredAttribute$str() {
        return "Task: Store a secured attribute";
    }

    @Override
    public final String taskStoreSecuredAttribute() {
        return String.format(this.getLoggingLocale(), this.taskStoreSecuredAttribute$str(), new Object[0]);
    }

    protected String interactivePromptSecureAttributeValue$str() {
        return "Please enter secured attribute value (such as password)";
    }

    @Override
    public final String interactivePromptSecureAttributeValue() {
        return String.format(this.getLoggingLocale(), this.interactivePromptSecureAttributeValue$str(), new Object[0]);
    }

    protected String interactivePromptSecureAttributeValueAgain$str() {
        return "Please enter secured attribute value again";
    }

    @Override
    public final String interactivePromptSecureAttributeValueAgain() {
        return String.format(this.getLoggingLocale(), this.interactivePromptSecureAttributeValueAgain$str(), new Object[0]);
    }

    protected String interactivePromptVaultBlock$str() {
        return "Enter Vault Block:";
    }

    @Override
    public final String interactivePromptVaultBlock() {
        return String.format(this.getLoggingLocale(), this.interactivePromptVaultBlock$str(), new Object[0]);
    }

    protected String interactivePromptAttributeName$str() {
        return "Enter Attribute Name:";
    }

    @Override
    public final String interactivePromptAttributeName() {
        return String.format(this.getLoggingLocale(), this.interactivePromptAttributeName$str(), new Object[0]);
    }

    protected String taskVerifySecuredAttributeExists$str() {
        return "Task: Verify whether a secured attribute exists";
    }

    @Override
    public final String taskVerifySecuredAttributeExists() {
        return String.format(this.getLoggingLocale(), this.taskVerifySecuredAttributeExists$str(), new Object[0]);
    }

    protected String interactiveMessageNoValueStored$str() {
        return "No value has been stored for %s";
    }

    @Override
    public final String interactiveMessageNoValueStored(String displayFormattedAttribute) {
        return String.format(this.getLoggingLocale(), this.interactiveMessageNoValueStored$str(), displayFormattedAttribute);
    }

    protected String interactiveMessageValueStored$str() {
        return "A value exists for %s";
    }

    @Override
    public final String interactiveMessageValueStored(String displayFormattedAttribute) {
        return String.format(this.getLoggingLocale(), this.interactiveMessageValueStored$str(), displayFormattedAttribute);
    }

    protected String taskRemoveSecuredAttribute$str() {
        return "Task: Remove secured attribute";
    }

    @Override
    public final String taskRemoveSecuredAttribute() {
        return String.format(this.getLoggingLocale(), this.taskRemoveSecuredAttribute$str(), new Object[0]);
    }

    protected String actionNotSpecified$str() {
        return "Action not specified";
    }

    @Override
    public final String actionNotSpecified() {
        return String.format(this.getLoggingLocale(), this.actionNotSpecified$str(), new Object[0]);
    }

    protected String unableToLocateJSSEConfig$str() {
        return "WFLYSEC0100: Legacy security domain %s doesn't contain a valid JSSE configuration";
    }

    @Override
    public final StartException unableToLocateJSSEConfig(String legacyDomainName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToLocateJSSEConfig$str(), legacyDomainName));
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToLocateComponentInJSSEDomain$str() {
        return "WFLYSEC0101: Unable to find a %s configuration in JSSE security domain %s";
    }

    @Override
    public final StartException unableToLocateComponentInJSSEDomain(String componentName, String legacyDomainName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToLocateComponentInJSSEDomain$str(), componentName, legacyDomainName));
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String expectedManagerTypeNotFound$str() {
        return "WFLYSEC0102: Could not find a %s of type %s in the JSSE security domain %s";
    }

    @Override
    public final StartException expectedManagerTypeNotFound(String managerName, String managerType, String legacyDomainName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.expectedManagerTypeNotFound$str(), managerName, managerType, legacyDomainName));
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCreateAuthorizationIdentity$str() {
        return "WFLYSEC0103: Unable to create AuthorizationIdentity: no authenticated Subject was found";
    }

    @Override
    public final IllegalStateException unableToCreateAuthorizationIdentity() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToCreateAuthorizationIdentity$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void defaultCacheRequirementMissing(String containerName, String legacyCacheName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.defaultCacheRequirementMissing$str(), (Object)containerName, (Object)legacyCacheName);
    }

    protected String defaultCacheRequirementMissing$str() {
        return "WFLYSEC0104: Default %s cache capability missing.  Assuming %s as default-cache.";
    }
}

