/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.timeout.TimeoutEvent;
import io.smallrye.faulttolerance.core.timeout.TimeoutExecution;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatch;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import io.smallrye.faulttolerance.core.util.Preconditions;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

public class Timeout<V>
implements FaultToleranceStrategy<V> {
    final FaultToleranceStrategy<V> delegate;
    final String description;
    final long timeoutInMillis;
    final TimeoutWatcher watcher;
    final MetricsRecorder metricsRecorder;

    public Timeout(FaultToleranceStrategy<V> delegate, String description, long timeoutInMillis, TimeoutWatcher watcher, MetricsRecorder metricsRecorder) {
        this.delegate = Preconditions.checkNotNull(delegate, "Timeout delegate must be set");
        this.description = Preconditions.checkNotNull(description, "Timeout description must be set");
        this.timeoutInMillis = Preconditions.check(timeoutInMillis, timeoutInMillis > 0L, "Timeout must be > 0");
        this.watcher = Preconditions.checkNotNull(watcher, "Timeout watcher must be set");
        this.metricsRecorder = metricsRecorder == null ? MetricsRecorder.NO_OP : metricsRecorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V apply(InvocationContext<V> ctx) throws Exception {
        TimeoutExecution execution = new TimeoutExecution(Thread.currentThread(), this.timeoutInMillis, () -> ctx.fireEvent(new TimeoutEvent(() -> Timeout.timeoutException(this.description))));
        TimeoutWatch watch = this.watcher.schedule(execution);
        long start = System.nanoTime();
        V result = null;
        Exception exception = null;
        boolean interrupted = false;
        try {
            result = this.delegate.apply(ctx);
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            execution.finish(watch::cancel);
        }
        if (Thread.interrupted()) {
            interrupted = true;
        }
        if (interrupted && !execution.hasTimedOut()) {
            exception = new InterruptedException();
        }
        long end = System.nanoTime();
        if (execution.hasTimedOut()) {
            this.metricsRecorder.timeoutTimedOut(end - start);
            throw Timeout.timeoutException(this.description);
        }
        if (exception != null) {
            this.metricsRecorder.timeoutFailed(end - start);
            throw exception;
        }
        this.metricsRecorder.timeoutSucceeded(end - start);
        return result;
    }

    static TimeoutException timeoutException(String description) {
        return new TimeoutException(description + " timed out");
    }

    public static interface MetricsRecorder {
        public static final MetricsRecorder NO_OP = new MetricsRecorder(){

            @Override
            public void timeoutSucceeded(long time) {
            }

            @Override
            public void timeoutTimedOut(long time) {
            }

            @Override
            public void timeoutFailed(long time) {
            }
        };

        public void timeoutSucceeded(long var1);

        public void timeoutTimedOut(long var1);

        public void timeoutFailed(long var1);
    }
}

