/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe.crypto;

import net.jcip.annotations.Immutable;
import org.jboss.resteasy.jose.i18n.Messages;

@Immutable
final class AuthenticatedCipherText {
    private final byte[] cipherText;
    private final byte[] authenticationTag;

    AuthenticatedCipherText(byte[] cipherText, byte[] authenticationTag) {
        if (cipherText == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.cipherTextMustNotBeNull());
        }
        this.cipherText = cipherText;
        if (authenticationTag == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.authenticationTagMustNotBeNull());
        }
        this.authenticationTag = authenticationTag;
    }

    public byte[] getCipherText() {
        return this.cipherText;
    }

    public byte[] getAuthenticationTag() {
        return this.authenticationTag;
    }
}

