/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jboss.as.clustering.context.Contextualizer;
import org.jboss.as.clustering.context.DefaultContextualizer;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.jboss.as.clustering.context.ExecutorServiceFactory;
import org.jboss.as.clustering.logging.ClusteringLogger;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.modules.ModuleLoader;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.Marshaller;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.Response;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.NameCache;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.GroupListener;
import org.wildfly.clustering.group.Membership;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.server.dispatcher.AutoCloseableCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcher;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherContext;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherMarshaller;
import org.wildfly.clustering.server.dispatcher.CommandResponseMarshaller;
import org.wildfly.clustering.server.dispatcher.LocalCommandDispatcher;
import org.wildfly.clustering.server.dispatcher.MarshallingConfigurationContext;
import org.wildfly.clustering.server.dispatcher.NoSuchService;
import org.wildfly.clustering.server.dispatcher.ViewMembership;
import org.wildfly.clustering.server.group.AddressableNode;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.service.concurrent.ServiceExecutor;
import org.wildfly.clustering.service.concurrent.StampedLockServiceExecutor;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.common.function.Functions;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ChannelCommandDispatcherFactory
implements AutoCloseableCommandDispatcherFactory,
RequestHandler,
org.wildfly.clustering.spi.group.Group<Address>,
MembershipListener,
Runnable,
Function<GroupListener, ExecutorService> {
    static final Optional<Object> NO_SUCH_SERVICE = Optional.of(NoSuchService.INSTANCE);
    static final ExceptionSupplier<Object, Exception> NO_SUCH_SERVICE_SUPPLIER = Functions.constantExceptionSupplier((Object)NoSuchService.INSTANCE);
    private final ConcurrentMap<Address, Node> members = new ConcurrentHashMap<Address, Node>();
    private final Map<Object, CommandDispatcherContext<?, ?>> contexts = new ConcurrentHashMap();
    private final ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory(this.getClass()));
    private final ServiceExecutor executor = new StampedLockServiceExecutor();
    private final Map<GroupListener, ExecutorService> listeners = new ConcurrentHashMap<GroupListener, ExecutorService>();
    private final AtomicReference<View> view = new AtomicReference();
    private final MarshallingContext marshallingContext;
    private final MessageDispatcher dispatcher;
    private final Duration timeout;
    private final ModuleLoader loader;

    public ChannelCommandDispatcherFactory(ChannelCommandDispatcherFactoryConfiguration config) {
        this.marshallingContext = config.getMarshallingContext();
        this.timeout = config.getTimeout();
        this.loader = config.getModuleLoader();
        JChannel channel = config.getChannel();
        RequestCorrelator correlator = new RequestCorrelator((Protocol)channel.getProtocolStack(), (RequestHandler)this, channel.getAddress()).setMarshaller((Marshaller)new CommandResponseMarshaller(config));
        this.dispatcher = new MessageDispatcher().setChannel(channel).setRequestHandler((RequestHandler)this).setMembershipListener((MembershipListener)this).asyncDispatching(true).correlator(correlator);
        this.view.compareAndSet(null, channel.getView());
    }

    @Override
    public void run() {
        this.shutdown(this.executorService);
        this.dispatcher.stop();
        this.dispatcher.getChannel().setUpHandler(null);
        for (ExecutorService executor : this.listeners.values()) {
            this.shutdown(executor);
        }
        this.listeners.clear();
    }

    @Override
    public void close() {
        this.executor.close((Runnable)this);
    }

    private void shutdown(ExecutorService executor) {
        WildFlySecurityManager.doUnchecked((Object)executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        try {
            executor.awaitTermination(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Object handle(Message request) throws Exception {
        return this.read(request).get();
    }

    public void handle(Message request, final Response response) throws Exception {
        final ExceptionSupplier<Object, Exception> commandTask = this.read(request);
        Runnable responseTask = new Runnable(){

            @Override
            public void run() {
                try {
                    response.send(commandTask.get(), false);
                }
                catch (Exception e) {
                    response.send((Object)e, true);
                }
            }
        };
        try {
            this.executorService.submit(responseTask);
        }
        catch (RejectedExecutionException e) {
            response.send((Object)NoSuchService.INSTANCE, false);
        }
    }

    /*
     * Exception decompiling
     */
    private ExceptionSupplier<Object, Exception> read(Message message) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Group getGroup() {
        return this;
    }

    public <C> CommandDispatcher<C> createCommandDispatcher(Object id, final C commandContext, final ClassLoader loader) {
        DefaultContextualizer contextualizer = new DefaultContextualizer();
        final ModuleLoader moduleLoader = this.loader;
        MarshallingConfigurationContext marshallingConfigurationContext = new MarshallingConfigurationContext(){

            @Override
            public ClassLoader getClassLoader() {
                return loader;
            }

            @Override
            public ModuleLoader getModuleLoader() {
                return moduleLoader;
            }
        };
        SimpleMarshallingContext marshallingContext = new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)marshallingConfigurationContext), loader);
        SimpleMarshalledValueFactory factory = new SimpleMarshalledValueFactory((MarshallingContext)marshallingContext);
        CommandDispatcherContext context = new CommandDispatcherContext<C, MarshallingContext>((Contextualizer)contextualizer, (MarshalledValueFactory)factory){
            final /* synthetic */ Contextualizer val$contextualizer;
            final /* synthetic */ MarshalledValueFactory val$factory;
            {
                this.val$contextualizer = contextualizer;
                this.val$factory = marshalledValueFactory;
            }

            @Override
            public C getCommandContext() {
                return commandContext;
            }

            @Override
            public Contextualizer getContextualizer() {
                return this.val$contextualizer;
            }

            @Override
            public MarshalledValueFactory<MarshallingContext> getMarshalledValueFactory() {
                return this.val$factory;
            }
        };
        if (this.contexts.putIfAbsent(id, context) != null) {
            throw ClusteringServerLogger.ROOT_LOGGER.commandDispatcherAlreadyExists(id);
        }
        CommandDispatcherMarshaller marshaller = new CommandDispatcherMarshaller(this.marshallingContext, id, factory);
        LocalCommandDispatcher localDispatcher = new LocalCommandDispatcher(this.getLocalMember(), commandContext);
        return new ChannelCommandDispatcher<C, SimpleMarshallingContext>(this.dispatcher, marshaller, marshallingContext, this, this.timeout, localDispatcher, () -> {
            localDispatcher.close();
            this.contexts.remove(id);
        });
    }

    public Registration register(GroupListener listener) {
        this.listeners.computeIfAbsent(listener, this);
        return () -> this.unregister(listener);
    }

    @Override
    public ExecutorService apply(GroupListener listener) {
        return new DefaultExecutorService(listener.getClass(), (Function)ExecutorServiceFactory.SINGLE_THREAD);
    }

    private void unregister(GroupListener listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            this.shutdown(executor);
        }
    }

    @Deprecated
    public void removeListener(Group.Listener listener) {
        this.unregister((GroupListener)listener);
    }

    public String getName() {
        return this.dispatcher.getChannel().getClusterName();
    }

    public Membership getMembership() {
        return new ViewMembership(this.dispatcher.getChannel().getAddress(), this.view.get(), (NodeFactory<Address>)this);
    }

    public Node getLocalMember() {
        return this.createNode(this.dispatcher.getChannel().getAddress());
    }

    public boolean isSingleton() {
        return false;
    }

    public Node createNode(Address address) {
        return this.members.computeIfAbsent(address, key -> {
            IpAddress ipAddress = (IpAddress)this.dispatcher.getChannel().down(new Event(87, (Object)address));
            InetSocketAddress socketAddress = ipAddress != null ? new InetSocketAddress(ipAddress.getIpAddress(), ipAddress.getPort()) : new InetSocketAddress(0);
            String name = Optional.ofNullable(NameCache.get((Address)address)).orElseGet(() -> String.format("%s:%s", socketAddress.getHostString(), socketAddress.getPort()));
            return new AddressableNode(address, name, socketAddress);
        });
    }

    public Address getAddress(Node node) {
        return ((AddressableNode)node).getAddress();
    }

    public void viewAccepted(final View view) {
        View oldView = this.view.getAndSet(view);
        if (oldView != null) {
            List leftMembers = View.leftMembers((View)oldView, (View)view);
            if (leftMembers != null) {
                this.members.keySet().removeAll(leftMembers);
            }
            if (!this.listeners.isEmpty()) {
                Address localAddress = this.dispatcher.getChannel().getAddress();
                final ViewMembership oldMembership = new ViewMembership(localAddress, oldView, (NodeFactory<Address>)this);
                final ViewMembership membership = new ViewMembership(localAddress, view, (NodeFactory<Address>)this);
                for (Map.Entry<GroupListener, ExecutorService> entry : this.listeners.entrySet()) {
                    final GroupListener listener = entry.getKey();
                    ExecutorService executor = entry.getValue();
                    Runnable listenerTask = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                listener.membershipChanged((Membership)oldMembership, (Membership)membership, view instanceof MergeView);
                            }
                            catch (Throwable e) {
                                ClusteringLogger.ROOT_LOGGER.warn((Object)e.getLocalizedMessage(), e);
                            }
                        }
                    };
                    try {
                        executor.submit(listenerTask);
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {}
                }
            }
        }
    }

    public void suspect(Address member) {
    }

    public void block() {
    }

    public void unblock() {
    }

    static enum MarshallingVersion implements Function<MarshallingConfigurationContext, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(MarshallingConfigurationContext context) {
                ClassLoader[] classLoaderArray;
                ClassLoader loader;
                MarshallingConfiguration config = new MarshallingConfiguration();
                ClassLoader userLoader = context.getClassLoader();
                if (userLoader.equals(loader = WildFlySecurityManager.getClassLoaderPrivileged(ChannelCommandDispatcherFactory.class))) {
                    ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                    classLoaderArray = classLoaderArray2;
                    classLoaderArray2[0] = userLoader;
                } else {
                    ClassLoader[] classLoaderArray3 = new ClassLoader[2];
                    classLoaderArray3[0] = userLoader;
                    classLoaderArray = classLoaderArray3;
                    classLoaderArray3[1] = loader;
                }
                ClassLoader[] loaders = classLoaderArray;
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)context.getModuleLoader()));
                config.setClassTable((ClassTable)new DynamicClassTable(loaders));
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable(loaders));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_1;
        }
    }
}

