/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.cli.command.aesh.activator;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.wildfly.core.cli.command.aesh.activator.DependOneOfOptionActivator;

public abstract class AbstractDependOneOfOptionActivator
implements DependOneOfOptionActivator {
    private final Set<String> options;

    protected AbstractDependOneOfOptionActivator(String ... opts) {
        this.options = new HashSet<String>(Arrays.asList(opts));
    }

    protected AbstractDependOneOfOptionActivator(Set<String> opts) {
        this.options = opts;
    }

    public boolean isActivated(ParsedCommand processedCommand) {
        boolean found = false;
        for (String opt : this.options) {
            if ("".equals(opt)) {
                found |= processedCommand.argument() != null && processedCommand.argument().value() != null;
                continue;
            }
            ParsedOption processedOption = processedCommand.findLongOptionNoActivatorCheck(opt);
            found |= processedOption != null && processedOption.value() != null;
        }
        return found;
    }

    @Override
    public Set<String> getOneOfDependsOn() {
        return Collections.unmodifiableSet(this.options);
    }
}

