/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.concurrent;

import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedCallable;
import io.opentracing.contrib.concurrent.TracedExecutor;
import io.opentracing.contrib.concurrent.TracedRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TracedExecutorService
extends TracedExecutor
implements ExecutorService {
    private final ExecutorService delegate;

    public TracedExecutorService(ExecutorService delegate, Tracer tracer) {
        this(delegate, tracer, true);
    }

    public TracedExecutorService(ExecutorService delegate, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(delegate, tracer, traceWithActiveSpanOnly);
        this.delegate = delegate;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        Scope scope = this.createScope("submit");
        try {
            Future future = this.delegate.submit(this.tracer.activeSpan() == null ? callable : new TracedCallable(callable, this.tracer));
            return future;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        Scope scope = this.createScope("submit");
        try {
            Future<T> future = this.delegate.submit(this.tracer.activeSpan() == null ? runnable : new TracedRunnable(runnable, this.tracer), t);
            return future;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> submit(Runnable runnable) {
        Scope scope = this.createScope("submit");
        try {
            Future<?> future = this.delegate.submit(this.tracer.activeSpan() == null ? runnable : new TracedRunnable(runnable, this.tracer));
            return future;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        Scope scope = this.createScope("invokeAll");
        try {
            List<Future<T>> list = this.delegate.invokeAll(this.toTraced(collection));
            return list;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        Scope scope = this.createScope("invokeAll");
        try {
            List<Future<T>> list = this.delegate.invokeAll(this.toTraced(collection), l, timeUnit);
            return list;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        Scope scope = this.createScope("invokeAny");
        try {
            T t = this.delegate.invokeAny(this.toTraced(collection));
            return t;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Scope scope = this.createScope("invokeAny");
        try {
            T t = this.delegate.invokeAny(this.toTraced(collection), l, timeUnit);
            return t;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    private <T> Collection<? extends Callable<T>> toTraced(Collection<? extends Callable<T>> delegate) {
        ArrayList tracedCallables = new ArrayList(delegate.size());
        for (TracedCallable tracedCallable : delegate) {
            tracedCallables.add(this.tracer.activeSpan() == null ? tracedCallable : new TracedCallable(tracedCallable, this.tracer));
        }
        return tracedCallables;
    }
}

