/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.applicationimpl;

import com.sun.faces.RIConstants;
import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.MethodBindingMethodExpressionAdapter;
import com.sun.faces.application.ValueBindingValueExpressionAdapter;
import com.sun.faces.application.applicationimpl.Version;
import com.sun.faces.el.ELUtils;
import com.sun.faces.el.FacesCompositeELResolver;
import com.sun.faces.el.PropertyResolverImpl;
import com.sun.faces.el.VariableResolverImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.CompositeELResolver;
import javax.el.ELContextListener;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;

public class ExpressionLanguage {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final ELContextListener[] EMPTY_EL_CTX_LIST_ARRAY = new ELContextListener[0];
    private final ApplicationAssociate associate;
    private volatile PropertyResolverImpl propertyResolver;
    private volatile VariableResolverImpl variableResolver;
    private List<ELContextListener> elContextListeners;
    private CompositeELResolver elResolvers;
    private volatile FacesCompositeELResolver compositeELResolver;
    private Version version = new Version();

    public ExpressionLanguage(ApplicationAssociate applicationAssociate) {
        this.associate = applicationAssociate;
        this.propertyResolver = new PropertyResolverImpl();
        this.variableResolver = new VariableResolverImpl();
        this.elContextListeners = new CopyOnWriteArrayList<ELContextListener>();
        this.elResolvers = new CompositeELResolver();
    }

    public void addELContextListener(ELContextListener listener) {
        if (listener != null) {
            this.elContextListeners.add(listener);
        }
    }

    public void removeELContextListener(ELContextListener listener) {
        if (listener != null) {
            this.elContextListeners.remove(listener);
        }
    }

    public ELContextListener[] getELContextListeners() {
        if (!this.elContextListeners.isEmpty()) {
            return this.elContextListeners.toArray(new ELContextListener[this.elContextListeners.size()]);
        }
        return EMPTY_EL_CTX_LIST_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ELResolver getELResolver() {
        if (this.compositeELResolver == null) {
            ExpressionLanguage expressionLanguage = this;
            synchronized (expressionLanguage) {
                if (this.compositeELResolver == null) {
                    this.performOneTimeELInitialization();
                }
            }
        }
        return this.compositeELResolver;
    }

    public void addELResolver(ELResolver resolver) {
        if (this.associate.hasRequestBeenServiced()) {
            throw new IllegalStateException(MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_ATTEMPT_SETTING_APPLICATION_ARTIFACT", "ELResolver"));
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (this.version.isJsf23()) {
            BeanManager cdiBeanManager = Util.getCdiBeanManager(facesContext);
            if (cdiBeanManager != null && !resolver.equals(cdiBeanManager.getELResolver())) {
                this.elResolvers.add(resolver);
            }
        } else {
            this.elResolvers.add(resolver);
        }
    }

    public ExpressionFactory getExpressionFactory() {
        return this.associate.getExpressionFactory();
    }

    public <T> T evaluateExpressionGet(FacesContext context, String expression, Class<? extends T> expectedType) throws ELException {
        return (T)this.getExpressionFactory().createValueExpression(context.getELContext(), expression, expectedType).getValue(context.getELContext());
    }

    public CompositeELResolver getApplicationELResolvers() {
        return this.elResolvers;
    }

    public FacesCompositeELResolver getCompositeELResolver() {
        return this.compositeELResolver;
    }

    public void setCompositeELResolver(FacesCompositeELResolver compositeELResolver) {
        this.compositeELResolver = compositeELResolver;
    }

    private void performOneTimeELInitialization() {
        if (this.compositeELResolver != null) {
            throw new IllegalStateException("Class invariant invalidated: The Application instance's ELResolver is not null and it should be.");
        }
        this.associate.initializeELResolverChains();
    }

    @Deprecated
    public PropertyResolver getPropertyResolver() {
        if (this.compositeELResolver == null) {
            this.performOneTimeELInitialization();
        }
        return this.propertyResolver;
    }

    @Deprecated
    public void setPropertyResolver(PropertyResolver resolver) {
        if (this.associate.hasRequestBeenServiced()) {
            throw new IllegalStateException(MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_ATTEMPT_SETTING_APPLICATION_ARTIFACT", "PropertyResolver"));
        }
        if (resolver == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "resolver");
            throw new NullPointerException(message);
        }
        this.propertyResolver.setDelegate(ELUtils.getDelegatePR(this.associate, true));
        this.associate.setLegacyPropertyResolver(resolver);
        this.propertyResolver = new PropertyResolverImpl();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("set PropertyResolver Instance to ''{0}''", resolver.getClass().getName()));
        }
    }

    @Deprecated
    public MethodBinding createMethodBinding(String ref, Class<?>[] params) {
        MethodExpression result;
        Util.notNull("ref", ref);
        if (!ref.startsWith("#{") || !ref.endsWith("}")) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(MessageFormat.format("Expression ''{0}'' does not follow the syntax #{...}", ref));
            }
            throw new ReferenceSyntaxException(ref);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            if (null == params) {
                params = RIConstants.EMPTY_CLASS_ARGS;
            }
            result = this.getExpressionFactory().createMethodExpression(context.getELContext(), ref, null, (Class[])params);
        }
        catch (ELException elex) {
            throw new ReferenceSyntaxException((Throwable)elex);
        }
        return new MethodBindingMethodExpressionAdapter(result);
    }

    @Deprecated
    public ValueBinding createValueBinding(String ref) throws ReferenceSyntaxException {
        ValueExpression result;
        Util.notNull("ref", ref);
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            result = this.getExpressionFactory().createValueExpression(context.getELContext(), ref, Object.class);
        }
        catch (ELException elex) {
            throw new ReferenceSyntaxException((Throwable)elex);
        }
        return new ValueBindingValueExpressionAdapter(result);
    }

    @Deprecated
    public VariableResolver getVariableResolver() {
        if (this.compositeELResolver == null) {
            this.performOneTimeELInitialization();
        }
        return this.variableResolver;
    }

    @Deprecated
    public void setVariableResolver(VariableResolver resolver) {
        Util.notNull("variableResolver", resolver);
        Util.canSetAppArtifact(this.associate, "VariableResolver");
        this.variableResolver.setDelegate(ELUtils.getDelegateVR(this.associate, true));
        this.associate.setLegacyVariableResolver(resolver);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(MessageFormat.format("set VariableResolver Instance to ''{0}''", ((Object)((Object)this.variableResolver)).getClass().getName()));
        }
    }
}

