/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.as.clustering.controller.AbstractCapabilityReference;
import org.jboss.as.clustering.controller.BinaryCapabilityNameResolver;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.SimpleCapabilityNameResolver;
import org.jboss.as.clustering.controller.UnaryCapabilityNameResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.BinaryRequirement;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.UnaryRequirement;

public class PredicateCapabilityReference
extends AbstractCapabilityReference {
    private static final Predicate<ModelNode> BOOLEAN = ModelNode::asBoolean;
    private final Function<PathAddress, String[]> requirementNameResolver;
    private final Predicate<ModelNode> predicate;

    public PredicateCapabilityReference(Capability capability, Requirement requirement) {
        this(capability, requirement, new SimpleCapabilityNameResolver(new String[0]), BOOLEAN);
    }

    public PredicateCapabilityReference(Capability capability, Requirement requirement, Predicate<ModelNode> predicate) {
        this(capability, requirement, new SimpleCapabilityNameResolver(new String[0]), predicate);
    }

    public PredicateCapabilityReference(Capability capability, UnaryRequirement requirement, UnaryCapabilityNameResolver requirementNameResolver) {
        this(capability, requirement, requirementNameResolver, BOOLEAN);
    }

    public PredicateCapabilityReference(Capability capability, UnaryRequirement requirement, UnaryCapabilityNameResolver requirementNameResolver, Predicate<ModelNode> predicate) {
        this(capability, (Requirement)requirement, (Function<PathAddress, String[]>)requirementNameResolver, predicate);
    }

    public PredicateCapabilityReference(Capability capability, BinaryRequirement requirement, BinaryCapabilityNameResolver requirementNameResolver) {
        this(capability, (Requirement)requirement, (Function<PathAddress, String[]>)requirementNameResolver, BOOLEAN);
    }

    public PredicateCapabilityReference(Capability capability, BinaryRequirement requirement, BinaryCapabilityNameResolver requirementNameResolver, Predicate<ModelNode> predicate) {
        this(capability, (Requirement)requirement, (Function<PathAddress, String[]>)requirementNameResolver, predicate);
    }

    private PredicateCapabilityReference(Capability capability, Requirement requirement, Function<PathAddress, String[]> requirementNameResolver, Predicate<ModelNode> predicate) {
        super(capability, requirement);
        this.requirementNameResolver = requirementNameResolver;
        this.predicate = predicate;
    }

    public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
        for (String value : values) {
            if (!this.predicate.test(new ModelNode(value))) continue;
            context.registerAdditionalCapabilityRequirement(this.getRequirementName(context), this.getDependentName(context), attributeName);
        }
    }

    public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
        for (String value : values) {
            if (!this.predicate.test(new ModelNode(value))) continue;
            context.deregisterCapabilityRequirement(this.getRequirementName(context), this.getDependentName(context));
        }
    }

    private String getRequirementName(OperationContext context) {
        String[] parts = this.requirementNameResolver.apply(context.getCurrentAddress());
        return parts.length > 0 ? RuntimeCapability.buildDynamicCapabilityName((String)this.getBaseRequirementName(), (String[])parts) : this.getBaseRequirementName();
    }

    public String[] getRequirementPatternSegments(String name, PathAddress address) {
        String[] segments = this.requirementNameResolver.apply(address);
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            if (segment.charAt(0) != '$') continue;
            segments[i] = segment.substring(1);
        }
        return segments;
    }
}

