/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.fine;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineImmutableSessionAttributes<K, V>
implements ImmutableSessionAttributes {
    private final Map<String, UUID> names;
    private final Function<UUID, K> keyFactory;
    private final Map<K, V> attributeCache;
    private final Marshaller<Object, V> marshaller;

    public FineImmutableSessionAttributes(Map<String, UUID> names, Function<UUID, K> keyFactory, Map<K, V> attributeCache, Marshaller<Object, V> marshaller) {
        this.names = Collections.unmodifiableMap(names);
        this.keyFactory = keyFactory;
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
    }

    public Set<String> getAttributeNames() {
        return this.names.keySet();
    }

    public Object getAttribute(String name) {
        UUID attributeId = this.names.get(name);
        if (attributeId == null) {
            return null;
        }
        K key = this.keyFactory.apply(attributeId);
        return this.read(this.attributeCache.get(key));
    }

    private Object read(V value) {
        try {
            return this.marshaller.read(value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

