/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collections;
import java.util.Properties;
import java.util.function.Consumer;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public abstract class StoreServiceConfigurator<C extends StoreConfiguration, B extends AbstractStoreConfigurationBuilder<C, B>>
extends ComponentServiceConfigurator<PersistenceConfiguration>
implements Consumer<B> {
    private final SupplierDependency<AsyncStoreConfiguration> async;
    private final Class<B> builderClass;
    private final Properties properties = new Properties();
    private volatile boolean passivation;
    private volatile boolean fetchState;
    private volatile boolean preload;
    private volatile boolean purge;
    private volatile boolean shared;
    private volatile int maxBatchSize;

    protected StoreServiceConfigurator(PathAddress address, Class<B> builderClass) {
        super(CacheComponent.PERSISTENCE, address);
        this.builderClass = builderClass;
        this.async = new ServiceSupplierDependency(CacheComponent.STORE_WRITE.getServiceName(address.getParent()));
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return super.register(this.async.register(builder));
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.passivation = StoreResourceDefinition.Attribute.PASSIVATION.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.fetchState = StoreResourceDefinition.Attribute.FETCH_STATE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.preload = StoreResourceDefinition.Attribute.PRELOAD.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.purge = StoreResourceDefinition.Attribute.PURGE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.shared = StoreResourceDefinition.Attribute.SHARED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.maxBatchSize = StoreResourceDefinition.Attribute.MAX_BATCH_SIZE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.properties.clear();
        for (Property property : ModelNodes.optionalPropertyList((ModelNode)StoreResourceDefinition.Attribute.PROPERTIES.resolveModelAttribute((ExpressionResolver)context, model)).orElse(Collections.emptyList())) {
            this.properties.setProperty(property.getName(), property.getValue().asString());
        }
        return this;
    }

    @Override
    public PersistenceConfiguration get() {
        AbstractStoreConfigurationBuilder builder = ((AbstractStoreConfigurationBuilder)new ConfigurationBuilder().persistence().passivation(this.passivation).addStore(this.builderClass)).fetchPersistentState(this.fetchState).maxBatchSize(this.maxBatchSize).preload(this.preload).purgeOnStartup(this.purge).shared(this.shared).withProperties(this.properties);
        this.accept(builder);
        return builder.async().read((AsyncStoreConfiguration)this.async.get()).persistence().create();
    }
}

