/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import java.util.OptionalInt;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReaderContext;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriterContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum AnyMarshaller implements ProtoStreamMarshaller<Any>
{
    INSTANCE;


    public Class<? extends Any> getJavaClass() {
        return Any.class;
    }

    public Any readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        int tag = reader.readTag();
        if (tag == 0) {
            return new Any(null);
        }
        AnyField field = AnyField.fromIndex(WireFormat.getTagFieldNumber((int)tag));
        if (field == null) {
            throw new StreamCorruptedException(String.valueOf(tag));
        }
        Object value = field.readFrom(context, reader);
        if (field == AnyField.REFERENCE) {
            value = ProtoStreamReaderContext.INSTANCE.get().findByReference((Integer)value);
        } else {
            ProtoStreamReaderContext.INSTANCE.get().setReference(value);
        }
        if (reader.readTag() != 0) {
            throw new StreamCorruptedException();
        }
        return new Any(value);
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Any value) throws IOException {
        Object object = value.get();
        if (object == null) {
            return;
        }
        Integer referenceId = ProtoStreamWriterContext.INSTANCE.get().getReferenceId(object);
        AnyField field = referenceId == null ? AnyMarshaller.getField(context, object) : AnyField.REFERENCE;
        writer.writeTag(field.getIndex(), 0);
        field.writeTo(context, writer, referenceId == null ? object : referenceId);
        if (referenceId == null) {
            ProtoStreamWriterContext.INSTANCE.get().setReference(object);
        }
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, Any value) {
        Object object = value.get();
        if (object == null) {
            return OptionalInt.of(0);
        }
        Integer referenceId = ProtoStreamWriterContext.INSTANCE.get().getReferenceId(object);
        AnyField field = referenceId == null ? AnyMarshaller.getField(context, object) : AnyField.REFERENCE;
        OptionalInt size = field.size(context, referenceId == null ? object : referenceId);
        return size.isPresent() ? OptionalInt.of(size.getAsInt() + Predictable.unsignedIntSize(field.getIndex() << 3 | 0)) : OptionalInt.empty();
    }

    private static AnyField getField(ImmutableSerializationContext context, Object value) {
        Class<?> valueClass = value.getClass();
        AnyField field = AnyField.fromJavaType(valueClass);
        if (field != null) {
            return field;
        }
        if (value instanceof Class) {
            Class targetClass = (Class)value;
            if (targetClass == Object.class) {
                return AnyField.OBJECT_CLASS;
            }
            AnyField classField = AnyField.fromJavaType(targetClass);
            if (classField != null) {
                return AnyField.FIELD_CLASS;
            }
            if (targetClass.isArray()) {
                return AnyField.ARRAY_CLASS;
            }
            try {
                BaseMarshaller marshaller = context.getMarshaller(targetClass);
                return AnyMarshaller.hasTypeId(context, marshaller) ? AnyField.IDENTIFIED_CLASS : AnyField.NAMED_CLASS;
            }
            catch (IllegalArgumentException e) {
                return AnyField.LOADED_CLASS;
            }
        }
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            BaseMarshaller marshaller = context.getMarshaller(enumValue.getDeclaringClass());
            return AnyMarshaller.hasTypeId(context, marshaller) ? AnyField.IDENTIFIED_ENUM : AnyField.ENUM;
        }
        if (valueClass.isArray()) {
            Class<?> componentType = valueClass.getComponentType();
            AnyField componentTypeField = AnyField.fromJavaType(componentType);
            if (componentTypeField != null) {
                return AnyField.FIELD_ARRAY;
            }
            if (componentType.isArray()) {
                return AnyField.MULTI_DIMENSIONAL_ARRAY;
            }
            try {
                BaseMarshaller marshaller = context.getMarshaller(componentType);
                return AnyMarshaller.hasTypeId(context, marshaller) ? AnyField.IDENTIFIED_ARRAY : AnyField.ARRAY;
            }
            catch (IllegalArgumentException e) {
                return AnyField.ARRAY;
            }
        }
        if (value instanceof Throwable && WildFlySecurityManager.getClassLoaderPrivileged(value.getClass()) == WildFlySecurityManager.getClassLoaderPrivileged(Throwable.class)) {
            return AnyField.THROWABLE;
        }
        if (Proxy.isProxyClass(valueClass)) {
            return AnyField.PROXY;
        }
        BaseMarshaller marshaller = context.getMarshaller(valueClass);
        return AnyMarshaller.hasTypeId(context, marshaller) ? AnyField.IDENTIFIED_OBJECT : AnyField.OBJECT;
    }

    private static boolean hasTypeId(ImmutableSerializationContext context, BaseMarshaller<?> marshaller) {
        return context.getDescriptorByName(marshaller.getTypeName()).getTypeId() != null;
    }
}

