/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReaderContext;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriterContext;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ProtoStreamByteBufferMarshaller
implements ByteBufferMarshaller {
    private final ImmutableSerializationContext context;
    private final Predictable<Any> marshaller;

    public ProtoStreamByteBufferMarshaller(ImmutableSerializationContext context) {
        this.context = context;
        this.marshaller = (ProtoStreamMarshaller)context.getMarshaller(Any.class);
    }

    public OptionalInt size(Object value) {
        return this.marshaller.size(this.context, new Any(value));
    }

    public boolean isMarshallable(Object object) {
        if (object == null || object instanceof Class) {
            return true;
        }
        Class<?> targetClass = object.getClass();
        if (object instanceof Throwable && WildFlySecurityManager.getClassLoaderPrivileged(targetClass) == WildFlySecurityManager.getClassLoaderPrivileged(Throwable.class)) {
            return true;
        }
        if (AnyField.fromJavaType(targetClass) != null) {
            return true;
        }
        if (targetClass.isArray()) {
            for (int i = 0; i < Array.getLength(object); ++i) {
                if (this.isMarshallable(Array.get(object, i))) continue;
                return false;
            }
            return true;
        }
        if (Proxy.isProxyClass(targetClass)) {
            return this.isMarshallable(Proxy.getInvocationHandler(object));
        }
        return this.context.canMarshall(targetClass);
    }

    public Object readFrom(InputStream input) throws IOException {
        try (ProtoStreamReaderContext context = ProtoStreamReaderContext.INSTANCE.get();){
            Object object = ((Any)ProtobufUtil.readFrom((ImmutableSerializationContext)this.context, (InputStream)input, Any.class)).get();
            return object;
        }
    }

    public void writeTo(OutputStream output, Object object) throws IOException {
        try (ProtoStreamWriterContext context = ProtoStreamWriterContext.INSTANCE.get();){
            ProtobufUtil.writeTo((ImmutableSerializationContext)this.context, (OutputStream)output, (Object)new Any(object));
        }
    }
}

