/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.function.Function;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ObjectMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public class SingletonCollectionMarshaller<T extends Collection<Object>>
implements ProtoStreamMarshaller<T> {
    private final Function<Object, T> factory;

    public SingletonCollectionMarshaller(Function<Object, T> factory) {
        this.factory = factory;
    }

    public T readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        Object value = ObjectMarshaller.INSTANCE.readFrom(context, reader);
        return (T)((Collection)this.factory.apply(value));
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, T collection) throws IOException {
        ObjectMarshaller.INSTANCE.writeTo(context, writer, collection.iterator().next());
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, T collection) {
        return ObjectMarshaller.INSTANCE.size(context, collection.iterator().next());
    }

    public Class<? extends T> getJavaClass() {
        return ((Collection)this.factory.apply(null)).getClass();
    }
}

