/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.logging;

import java.lang.reflect.Method;
import javax.naming.InvalidNameException;
import javax.naming.OperationNotSupportedException;
import javax.security.auth.login.LoginException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYSEC", length=4)
public interface SecurityLogger
extends BasicLogger {
    public static final SecurityLogger ROOT_LOGGER = (SecurityLogger)Logger.getMessageLogger(SecurityLogger.class, (String)"org.jboss.as.security");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Current PicketBox version=%s")
    public void currentVersion(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Activating Security Subsystem")
    public void activatingSecuritySubsystem();

    @Message(id=4, value="Unable to get the Module Class Loader")
    public IllegalStateException unableToGetModuleClassLoader(@Cause Throwable var1);

    @Message(id=5, value="Operation not supported : %s")
    public OperationNotSupportedException operationNotSupported(Method var1);

    @Message(id=6, value="Missing module name for the %s")
    public IllegalArgumentException missingModuleName(String var1);

    @Message(id=7, value="Runtime Exception:")
    public RuntimeException runtimeException(@Cause Throwable var1);

    @Message(id=9, value="Name cannot be null or empty")
    public InvalidNameException nullName();

    @Message(id=11, value="Argument %s is null")
    public IllegalArgumentException nullArgument(String var1);

    @Message(id=12, value="Unable to start the %s service")
    public StartException unableToStartException(String var1, @Cause Throwable var2);

    @Message(id=13, value="Class not found : %s")
    public ClassNotFoundException cnfe(String var1);

    @Message(id=15, value="Security Exception")
    public SecurityException securityException(@Cause Throwable var1);

    @Message(id=18, value="Use the ResourceDescriptionResolver variant")
    public UnsupportedOperationException unsupportedOperationExceptionUseResourceDesc();

    @Message(id=19, value="Unsupported Operation")
    public UnsupportedOperationException unsupportedOperation();

    @Message(id=22, value="A security domain can have either an <authentication> or <authentication-jaspi> element, not both")
    public XMLStreamException xmlStreamExceptionAuth(@Param Location var1);

    @Message(id=23, value="Missing required attribute: either %s or %s must be present")
    public XMLStreamException xmlStreamExceptionMissingAttribute(String var1, String var2, @Param Location var3);

    @Message(id=24, value="auth-module references a login module stack that doesn't exist::%s")
    public IllegalArgumentException loginModuleStackIllegalArgument(String var1);

    @Message(id=25, value="Address did not contain a security domain name")
    public IllegalArgumentException addressDidNotContainSecurityDomain();

    @Message(id=27, value="Invalid User")
    public SecurityException invalidUserException();

    @Message(id=28, value="Security Management not injected")
    public SecurityException securityManagementNotInjected();

    @Message(id=29, value="Security realm '%s' not found.")
    public SecurityException realmNotFound(String var1);

    @Message(id=31, value="Failure calling CallbackHandler '%s'")
    public LoginException failureCallingSecurityRealm(String var1);

    @Message(id=32, value="No authentication cache for security domain '%s' available")
    public OperationFailedException noAuthenticationCacheAvailable(String var1);

    @Message(id=33, value="No UserPrincipalFound constructing RemotingConnectionPrincipal.")
    public IllegalStateException noUserPrincipalFound();

    @Message(id=34, value="Interrupted waiting for security domain '%s'")
    public OperationFailedException interruptedWaitingForSecurityDomain(String var1);

    @Message(id=35, value="Required security domain is not available '%s'")
    public OperationFailedException requiredSecurityDomainServiceNotAvailable(String var1);

    @Deprecated
    @Message(id=61, value=" again: ")
    public String passwordAgain();

    @Message(id=100, value="Legacy security domain %s doesn't contain a valid JSSE configuration")
    public StartException unableToLocateJSSEConfig(String var1);

    @Message(id=101, value="Unable to find a %s configuration in JSSE security domain %s")
    public StartException unableToLocateComponentInJSSEDomain(String var1, String var2);

    @Message(id=102, value="Could not find a %s of type %s in the JSSE security domain %s")
    public StartException expectedManagerTypeNotFound(String var1, String var2, String var3);

    @Message(id=103, value="Unable to create AuthorizationIdentity: no authenticated Subject was found")
    public IllegalStateException unableToCreateAuthorizationIdentity();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=104, value="Default %s cache capability missing.  Assuming %s as default-cache.")
    public void defaultCacheRequirementMissing(String var1, String var2);
}

